var StateHelpers = (function () {
    function StateHelpers() {
        var _this = this;
        this.calculateNumberOfElements = function (_a) {
            var spec = _a.spec, showConfig = _a.showConfig;
            var showConfigKeys = Object.keys(showConfig);
            var fn = function (obj) {
                var numberOfElements = 0;
                Object.entries(obj).map(function (_a) {
                    var key = _a[0], value = _a[1];
                    var condition = Boolean(key !== 'info' && showConfigKeys.includes(key) && showConfig[key]);
                    if (condition) {
                        numberOfElements += 1;
                        if (Array.isArray(value)) {
                            numberOfElements += value.length;
                        }
                        if (typeof value === 'object') {
                            if (_this.isServers(value)) {
                                numberOfElements += _this.calculateServers(value);
                            }
                            else {
                                numberOfElements += Object.keys(value).length;
                            }
                        }
                    }
                });
                return numberOfElements;
            };
            return fn(spec) + fn(spec.components || {});
        };
        this.calculateInitialExpandedElements = function (_a) {
            var spec = _a.spec, showConfig = _a.showConfig, expandConfig = _a.expandConfig;
            var showConfigKeys = Object.keys(showConfig);
            var collapseConfigKeys = Object.keys(showConfig);
            var fn = function (obj) {
                var numberOfElements = 0;
                Object.entries(obj).map(function (_a) {
                    var key = _a[0], value = _a[1];
                    var condition = Boolean(key !== 'info' &&
                        showConfigKeys.includes(key) &&
                        showConfig[key] &&
                        collapseConfigKeys.includes(key) &&
                        expandConfig[key]);
                    if (condition) {
                        var field = expandConfig[key];
                        if (field.root) {
                            numberOfElements += 1;
                        }
                        if (!field.elements) {
                            return;
                        }
                        if (Array.isArray(value)) {
                            numberOfElements += value.length;
                        }
                        if (typeof value === 'object') {
                            if (_this.isServers(value)) {
                                numberOfElements += _this.calculateServers(value);
                            }
                            else {
                                numberOfElements += Object.keys(value).length;
                            }
                        }
                    }
                });
                return numberOfElements;
            };
            return fn(spec) + fn(spec.components || {});
        };
    }
    StateHelpers.prototype.calculateServers = function (servers) {
        if (!servers || !Object.keys(servers).length) {
            return 0;
        }
        var elements = 0;
        Object.entries(servers).map(function (_a) {
            var _ = _a[0], server = _a[1];
            elements += Number(Boolean(server.description && server.security && server.variables));
        });
        return elements;
    };
    StateHelpers.prototype.isServers = function (v) {
        if (!v || !Object.keys(v).length) {
            return false;
        }
        return !!v[Object.keys(v)[0]].protocol;
    };
    return StateHelpers;
}());
export var stateHelpers = new StateHelpers();
//# sourceMappingURL=stateHelpers.js.map