import { useEffect } from 'react';
import { useLocation } from 'react-use';
import createUseContext from 'constate';
import { useExpandedContext } from './useExpandedState';
import { extractHashData, scrollIntoViewOfAnchor } from '../helpers';
var useChangeHash = function (_a) {
    var schemaName = _a.schemaName, _b = _a.pushStateBehavior, pushStateBehavior = _b === void 0 ? scrollIntoViewOfAnchor : _b;
    var hash = useLocation().hash;
    var _c = useExpandedContext(), setClickedItem = _c.setClickedItem, scrollToView = _c.scrollToView;
    useEffect(function () {
        if (!hash) {
            return;
        }
        var hashData = extractHashData(hash);
        if (!hashData || hashData.schema !== schemaName) {
            return;
        }
        setClickedItem({
            label: hashData.container,
            itemName: hashData.item,
            state: true,
            scroll: true,
        });
    }, [hash]);
    useEffect(function () {
        if (!hash) {
            return;
        }
        var hashData = extractHashData(hash);
        if (!hashData || hashData.schema !== schemaName) {
            return;
        }
        pushStateBehavior && pushStateBehavior(hash);
    }, [scrollToView]);
};
export var useChangeHashContext = createUseContext(useChangeHash);
//# sourceMappingURL=useChangeHash.js.map