/// <reference types="react" />
import { ConfigInterface } from './config';
export declare type PrimitiveType = number | boolean | string | null;
export declare type PropsWithDefaults<T, D> = T & D;
export declare type ExcludeNullable<T> = Exclude<T, null | undefined>;
export interface TypeWithKey<TKey, TContent> {
    key: TKey;
    content: TContent;
}
export declare type DeepPartial<T> = {
    [P in keyof T]?: DeepPartial<T[P]>;
};
export declare type AsyncAPIVersion = string;
export declare type UniqueID = string;
export declare type DefaultContentType = string;
export declare type BaseTopic = string;
export declare type DescriptionHTML = string | React.ReactNode;
export declare type ExternalSpecification = Record<string, any>;
export declare type ReferenceString = string;
export declare type OneOf = 'oneOf';
export declare type AnyOf = 'anyOf';
export declare type SchemaType = 'array' | 'boolean' | 'integer' | 'null' | 'number' | 'object' | 'string';
export declare enum BindingsType {
    http = "http",
    ws = "ws",
    kafka = "kafka",
    amqp = "amqp",
    amqp1 = "amqp1",
    mqtt = "mqtt",
    mqtt5 = "mqtt5",
    nats = "nats",
    jms = "jms",
    sns = "sns",
    sqs = "sqs",
    stomp = "stomp",
    redis = "redis"
}
export declare type Bindings = keyof typeof BindingsType;
export interface BaseBindings {
    [key: string]: any;
}
export interface AsyncAPI {
    asyncapi: AsyncAPIVersion;
    id?: UniqueID;
    info: Info;
    servers?: Servers;
    channels: Channels;
    defaultContentType?: DefaultContentType;
    components?: Components;
    tags?: Tag[];
    externalDocs?: ExternalDocs;
}
export interface Info {
    title: string;
    version: string;
    description?: DescriptionHTML;
    termsOfService?: string;
    contact?: Contact;
    license?: License;
}
export interface Contact {
    name?: string;
    url?: string;
    email?: string;
}
export interface License {
    name: string;
    url?: string;
}
export interface Servers {
    [k: string]: Server;
}
export interface Server {
    url: string;
    protocol: string;
    protocolVersion?: string;
    description?: DescriptionHTML;
    variables?: ServerVariables;
    security?: SecurityRequirement[];
    bindings?: BaseBindings[];
}
export interface ServerVariables {
    [k: string]: ServerVariable;
}
export interface ServerVariable {
    enum?: string[];
    default?: string;
    description?: DescriptionHTML;
    examples?: string[];
}
export interface SecurityRequirement {
    [key: string]: string[];
}
export interface Channels {
    [key: string]: Channel;
}
export interface Channel {
    parameters?: Parameters;
    description?: DescriptionHTML;
    publish?: Operation;
    subscribe?: Operation;
    deprecated?: boolean;
    protocolInfo?: ProtocolInfo;
    bindings?: BaseBindings;
}
export interface OperationTrait {
    summary?: string;
    description?: DescriptionHTML;
    tags?: Tag[];
    externalDocs?: ExternalDocs;
    operationId?: string;
    protocolInfo?: any;
}
export declare type TraitType = OperationTrait | [OperationTrait, any];
export interface Operation {
    traits?: TraitType[];
    summary?: string;
    description?: DescriptionHTML;
    tags?: Tag[];
    externalDocs?: ExternalDocs;
    operationId?: string;
    protocolInfo?: ProtocolInfo;
    message?: Message;
    bindings?: BaseBindings[];
}
export interface ProtocolInfo {
    [key: string]: any;
}
export interface Parameters {
    [key: string]: Parameter;
}
export interface Topic {
    $ref?: ReferenceString;
    deprecated?: boolean;
    subscribe?: Message | Record<OneOf, Message[]>;
    publish?: Message | Record<OneOf, Message[]>;
    parameters?: Parameter[];
}
export interface Parameter {
    description?: DescriptionHTML;
    schema?: Schema;
    location?: string;
}
export interface Reference {
    $ref: ReferenceString;
}
export declare type Message = RawMessage | Record<OneOf, RawMessage[]>;
export declare function isRawMessage(message: Message): message is RawMessage;
export declare enum PayloadType {
    PUBLISH = "publish",
    SUBSCRIBE = "subscribe"
}
export declare function isOneOfPayload(payload: RawMessage['payload']): payload is Record<OneOf, Schema[]>;
export declare function isAnyOfPayload(payload: RawMessage['payload']): payload is Record<AnyOf, Schema[]>;
export interface RawMessage {
    schemaFormat?: string;
    contentType?: string;
    headers?: Schema;
    payload?: Schema | Record<OneOf, Schema[]> | Record<AnyOf, Schema[]>;
    correlationId?: CorrelationId;
    tags?: Tag[];
    summary?: DescriptionHTML;
    name?: string;
    title?: string;
    description?: DescriptionHTML;
    externalDocs?: ExternalDocs;
    deprecated?: boolean;
    examples?: Example[];
    protocolInfo?: any;
    traits?: MessageTrait | [MessageTrait, any];
    bindings?: BaseBindings;
}
export interface Tag {
    name: string;
    description?: string;
    externalDocs?: ExternalDocs;
}
export interface ExternalDocs {
    url: string;
    description?: DescriptionHTML;
}
export interface CorrelationId {
    description?: string;
    location: string;
}
export interface MessageTrait {
    schemaFormat?: string;
    contentType?: string;
    headers?: Schema;
    correlationId?: CorrelationId;
    tags?: Tag[];
    summary?: string;
    name?: string;
    title?: string;
    description?: DescriptionHTML;
    externalDocs?: ExternalDocs;
    deprecated?: boolean;
    examples?: Example[];
    protocolInfo?: Record<string, any>;
}
export interface Example {
    headers?: object;
    payload?: object;
}
export interface Components {
    schemas?: Record<string, Schema>;
    messages?: Record<string, Message>;
    securitySchemes?: Record<Bindings, SecurityScheme>;
    parameters?: Record<string, Parameter>;
    correlationIds?: CorrelationId;
    operationTraits?: Record<string, OperationTrait>;
    messageTraits?: Record<string, MessageTrait>;
}
export declare enum SecuritySchemeType {
    userPassword = "User / Password",
    apiKey = "API key",
    X509 = "X509",
    symmetricEncryption = "Symmetric Encryption",
    asymmetricEncryption = "Asymmetric Encryption",
    httpApiKey = "HTTP API key",
    http = "HTTP",
    oauth2 = "OAuth2",
    openIdConnect = "Open ID"
}
export declare type SecuritySchemeTypes = keyof typeof SecuritySchemeType;
export interface SecurityScheme {
    type: SecuritySchemeTypes;
    description?: DescriptionHTML;
    in: string;
    name: string;
    scheme: string;
    bearerFormat?: string;
    flows?: OAuthFlows;
    openIdConnectUrl?: string;
}
export declare enum OAuthFlowsType {
    implicit = "Implicit",
    password = "Password",
    clientCredentials = "Client Credentials",
    authorizationCode = "Authorization Code"
}
export declare type OAuthFlowsTypes = keyof typeof OAuthFlowsType;
export interface OAuthFlows {
    implicit?: OAuthFlow;
    password?: OAuthFlow;
    clientCredentials?: OAuthFlow;
    authorizationCode?: OAuthFlow;
}
export interface OAuthFlow {
    authorizationUrl: string;
    tokenUrl: string;
    refreshUrl?: string;
    scopes: Record<string, string>;
}
export interface XML {
    name?: string;
    namespace?: string;
    prefix?: string;
    attribute?: boolean;
    wrapped?: boolean;
}
export declare type AdditionalProperties = boolean | Record<string, Schema>;
export interface Schema {
    nullable?: boolean;
    format?: string;
    title?: string;
    description?: DescriptionHTML;
    default?: PrimitiveType | {};
    multipleOf?: number;
    maximum?: number;
    exclusiveMaximum?: boolean;
    minimum?: number;
    exclusiveMinimum?: boolean;
    maxLength?: number;
    minLength?: number;
    pattern?: RegExp | string;
    maxItems?: number;
    minItems?: number;
    uniqueItems?: boolean;
    maxProperties?: number;
    minProperties?: number;
    required?: string[];
    enum?: any[];
    deprecated?: boolean;
    const?: any;
    type?: SchemaType;
    items?: Schema;
    discriminator?: string;
    readOnly?: boolean;
    xml?: XML;
    externalDocs?: ExternalDocs;
    example?: any;
    examples?: any[];
    allOf?: Schema[];
    oneOf?: Schema[];
    anyOf?: Schema[];
    not?: Schema;
    properties?: Record<string, Schema>;
    additionalProperties?: AdditionalProperties;
}
export declare type PropsSchema = string | FetchingSchemaInterface | any;
export interface AsyncApiProps {
    schema: PropsSchema;
    config?: Partial<ConfigInterface>;
}
export declare type NullableAsyncApi = AsyncAPI | null;
export interface AsyncApiState {
    validatedSchema: NullableAsyncApi;
    error?: ErrorObject;
}
export declare function isFetchingSchemaInterface(schema: PropsSchema): schema is FetchingSchemaInterface;
export interface FetchingSchemaInterface {
    url: string;
    requestOptions?: RequestInit;
}
export interface ParserReturn {
    data: NullableAsyncApi;
    error?: ErrorObject;
}
export declare type TableColumnName = string;
export declare type PushStateBehavior = (hash: string) => void;
export interface Identifier {
    id: string;
    toKebabCase?: boolean;
}
export interface ValidationError {
    title: string;
    jsonPointer: string;
    startLine: number;
    startColumn: number;
    startOffset: number;
    endLine: number;
    endColumn: number;
    endOffset: number;
}
export interface ErrorObject {
    type: string;
    title: string;
    detail?: string;
    parsedJSON?: any;
    validationErrors?: ValidationError[];
    location?: {
        startLine: number;
        startColumn: number;
        startOffset: number;
    };
    refs?: Array<{
        title: string;
        jsonPointer: string;
        startLine: number;
        startColumn: number;
        startOffset: number;
        endLine: number;
        endColumn: number;
        endOffset: number;
    }>;
}
