export var BindingsType;
(function (BindingsType) {
    BindingsType["http"] = "http";
    BindingsType["ws"] = "ws";
    BindingsType["kafka"] = "kafka";
    BindingsType["amqp"] = "amqp";
    BindingsType["amqp1"] = "amqp1";
    BindingsType["mqtt"] = "mqtt";
    BindingsType["mqtt5"] = "mqtt5";
    BindingsType["nats"] = "nats";
    BindingsType["jms"] = "jms";
    BindingsType["sns"] = "sns";
    BindingsType["sqs"] = "sqs";
    BindingsType["stomp"] = "stomp";
    BindingsType["redis"] = "redis";
})(BindingsType || (BindingsType = {}));
export function isRawMessage(message) {
    return !message.oneOf;
}
export var PayloadType;
(function (PayloadType) {
    PayloadType["PUBLISH"] = "publish";
    PayloadType["SUBSCRIBE"] = "subscribe";
})(PayloadType || (PayloadType = {}));
export function isOneOfPayload(payload) {
    return !!payload && payload.oneOf !== undefined;
}
export function isAnyOfPayload(payload) {
    return !!payload && payload.anyOf !== undefined;
}
export var SecuritySchemeType;
(function (SecuritySchemeType) {
    SecuritySchemeType["userPassword"] = "User / Password";
    SecuritySchemeType["apiKey"] = "API key";
    SecuritySchemeType["X509"] = "X509";
    SecuritySchemeType["symmetricEncryption"] = "Symmetric Encryption";
    SecuritySchemeType["asymmetricEncryption"] = "Asymmetric Encryption";
    SecuritySchemeType["httpApiKey"] = "HTTP API key";
    SecuritySchemeType["http"] = "HTTP";
    SecuritySchemeType["oauth2"] = "OAuth2";
    SecuritySchemeType["openIdConnect"] = "Open ID";
})(SecuritySchemeType || (SecuritySchemeType = {}));
export var OAuthFlowsType;
(function (OAuthFlowsType) {
    OAuthFlowsType["implicit"] = "Implicit";
    OAuthFlowsType["password"] = "Password";
    OAuthFlowsType["clientCredentials"] = "Client Credentials";
    OAuthFlowsType["authorizationCode"] = "Authorization Code";
})(OAuthFlowsType || (OAuthFlowsType = {}));
export function isFetchingSchemaInterface(schema) {
    return schema.url !== undefined;
}
//# sourceMappingURL=types.js.map