"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Server = void 0;
var react_1 = __importDefault(require("react"));
var ServerSecurity_1 = require("./ServerSecurity");
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var Server = function (_a) {
    var serverName = _a.serverName, server = _a.server;
    var config = (0, contexts_1.useConfig)();
    if (!server) {
        return null;
    }
    var urlVariables = helpers_1.SchemaHelpers.serverVariablesToSchema(server.variables());
    var protocolVersion = server.protocolVersion();
    var serverRequirements = server.security();
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center px-8" },
            react_1.default.createElement("div", { className: "shadow rounded bg-gray-200 p-4 border bg-gray-100" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("span", { className: "font-mono text-base" }, server.url()),
                    react_1.default.createElement("span", { className: "bg-teal-500 font-bold no-underline text-white uppercase rounded mx-2 px-2 py-1 text-sm" }, protocolVersion
                        ? "".concat(server.protocol(), " ").concat(protocolVersion)
                        : server.protocol()),
                    react_1.default.createElement("span", { className: "bg-blue-500 font-bold no-underline text-white uppercase rounded px-2 py-1 text-sm" }, serverName)),
                server.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
                    react_1.default.createElement(components_1.Markdown, null, server.description()))),
                urlVariables && (react_1.default.createElement("div", { className: "mt-2", id: "".concat(helpers_1.CommonHelpers.getIdentifier("server-".concat(serverName, "-url-variables"), config)) },
                    react_1.default.createElement(components_1.Schema, { schemaName: "URL Variables", schema: urlVariables, expanded: true }))),
                react_1.default.createElement("div", { id: "".concat(helpers_1.CommonHelpers.getIdentifier("server-".concat(serverName, "-security"), config)) },
                    react_1.default.createElement(ServerSecurity_1.ServerSecurity, { protocol: server.protocol(), serverRequirements: serverRequirements })),
                server.hasBindings() && (react_1.default.createElement("div", { className: "mt-2" },
                    react_1.default.createElement(components_1.Bindings, { name: "Server specific information", bindings: server.bindings() }))))),
        react_1.default.createElement("div", { className: "panel-item--right" })));
};
exports.Server = Server;
//# sourceMappingURL=Server.js.map