"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerSecurity = void 0;
var react_1 = __importDefault(require("react"));
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var ServerSecurity = function (_a) {
    var _b = _a.serverRequirements, serverRequirements = _b === void 0 ? [] : _b, _c = _a.protocol, protocol = _c === void 0 ? '' : _c;
    var asyncapi = (0, contexts_1.useSpec)();
    var securitySchemes = asyncapi.hasComponents() && asyncapi.components().securitySchemes();
    var renderedServerSecurities;
    if (!serverRequirements ||
        !serverRequirements.length ||
        !securitySchemes ||
        !Object.keys(securitySchemes).length) {
        if (protocol === 'kafka' || protocol === 'kafka-secure') {
            renderedServerSecurities = (react_1.default.createElement(ServerSecurityItem, { protocol: protocol, securitySchema: null }));
        }
    }
    else {
        var serverSecurities = serverRequirements
            .map(function (requirement) {
            var def = securitySchemes[Object.keys(requirement.json())[0]];
            if (!def) {
                return null;
            }
            return (react_1.default.createElement(ServerSecurityItem, { protocol: protocol, securitySchema: def, key: def.type() }));
        })
            .filter(Boolean);
        renderedServerSecurities = (react_1.default.createElement("ul", null, serverSecurities.map(function (security, idx) { return (react_1.default.createElement("li", { className: "mt-2", key: idx }, security)); })));
    }
    if (!renderedServerSecurities) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "text-sm mt-4" },
        react_1.default.createElement("h5", { className: "text-gray-700 text-base" }, "Security:"),
        renderedServerSecurities));
};
exports.ServerSecurity = ServerSecurity;
function collectSecuritySchemas(securitySchema) {
    var schemas = [];
    if (securitySchema) {
        if (securitySchema.name()) {
            schemas.push(react_1.default.createElement("span", null,
                "Name: ",
                securitySchema.name()));
        }
        if (securitySchema.in()) {
            schemas.push(react_1.default.createElement("span", null,
                "In: ",
                securitySchema.in()));
        }
        if (securitySchema.scheme()) {
            schemas.push(react_1.default.createElement("span", null,
                "Scheme: ",
                securitySchema.scheme()));
        }
        if (securitySchema.bearerFormat()) {
            schemas.push(react_1.default.createElement("span", null,
                "Bearer format: ",
                securitySchema.bearerFormat()));
        }
        if (securitySchema.openIdConnectUrl()) {
            schemas.push(react_1.default.createElement(components_1.Href, { href: securitySchema.openIdConnectUrl(), className: "underline" }, "Connect URL"));
        }
    }
    return schemas;
}
var ServerSecurityItem = function (_a) {
    var securitySchema = _a.securitySchema, protocol = _a.protocol;
    var schemas = collectSecuritySchemas(securitySchema);
    var renderedKafkaSecurity;
    if (['kafka', 'kafka-secure'].includes(protocol)) {
        var _b = helpers_1.ServerHelpers.getKafkaSecurity(protocol, securitySchema), securityProtocol = _b.securityProtocol, saslMechanism = _b.saslMechanism;
        renderedKafkaSecurity = (react_1.default.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded" },
            securityProtocol && (react_1.default.createElement("div", { className: "mt-1" },
                react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "security.protocol:"),
                react_1.default.createElement("span", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, securityProtocol))),
            saslMechanism && (react_1.default.createElement("div", { className: "mt-1" },
                react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "sasl.mechanism:"),
                react_1.default.createElement("span", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, saslMechanism)))));
    }
    var flows = securitySchema && securitySchema.flows();
    var renderedFlows = flows &&
        Object.entries(flows).map(function (_a) {
            var flowName = _a[0], flow = _a[1];
            var authorizationUrl = flow.authorizationUrl();
            var tokenUrl = flow.tokenUrl();
            var refreshUrl = flow.refreshUrl();
            var scopes = flow.scopes();
            return (react_1.default.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded", key: flowName },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Flow:"),
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, helpers_1.ServerHelpers.flowName(flowName))),
                authorizationUrl && (react_1.default.createElement("div", { className: "mt-1" },
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Auth URL:"),
                    react_1.default.createElement(components_1.Href, { href: authorizationUrl, className: "underline" }, authorizationUrl))),
                tokenUrl && (react_1.default.createElement("div", { className: "mt-1" },
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Token URL:"),
                    react_1.default.createElement(components_1.Href, { href: tokenUrl, className: "underline" }, tokenUrl))),
                refreshUrl && (react_1.default.createElement("div", { className: "mt-1" },
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Refresh URL:"),
                    react_1.default.createElement(components_1.Href, { href: refreshUrl, className: "underline" }, refreshUrl))),
                scopes && (react_1.default.createElement("div", { className: "mt-1" },
                    react_1.default.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Scopes:"),
                    react_1.default.createElement("ul", { className: "inline-block" }, scopes &&
                        Object.entries(scopes).map(function (_a) {
                            var scopeName = _a[0], scopeDesc = _a[1];
                            return (react_1.default.createElement("li", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1", title: scopeDesc, key: scopeName }, scopeName));
                        }))))));
        });
    return (react_1.default.createElement("div", null,
        securitySchema && schemas && (react_1.default.createElement("div", null,
            react_1.default.createElement("span", null,
                helpers_1.ServerHelpers.securityType(securitySchema.type()),
                schemas.length > 0 && (react_1.default.createElement("ul", { className: "inline-block ml-2" }, schemas.map(function (schema, idx) { return (react_1.default.createElement("li", { className: "inline-block font-bold no-underline bg-blue-400 text-white text-xs uppercase rounded px-2 py-0 ml-1", key: idx }, schema)); })))))),
        securitySchema && securitySchema.hasDescription() && (react_1.default.createElement("div", null,
            react_1.default.createElement(components_1.Markdown, null, securitySchema.description()))),
        renderedFlows && renderedFlows.length > 0 && (react_1.default.createElement("ul", { className: "my-2" },
            react_1.default.createElement("li", null, renderedFlows))),
        renderedKafkaSecurity && react_1.default.createElement("div", null, renderedKafkaSecurity)));
};
//# sourceMappingURL=ServerSecurity.js.map