"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationsByOperationsTags = exports.OperationsByRootTags = exports.OperationsList = exports.Sidebar = void 0;
var react_1 = __importStar(require("react"));
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var SidebarContext = react_1.default.createContext({
    setShowSidebar: function (value) { return value; },
});
var Sidebar = function (_a) {
    var config = _a.config;
    var _b = (0, react_1.useState)(false), showSidebar = _b[0], setShowSidebar = _b[1];
    var showOperations = (config === null || config === void 0 ? void 0 : config.showOperations) || 'byDefault';
    var asyncapi = (0, contexts_1.useSpec)();
    var info = asyncapi.info();
    var logo = info.ext('x-logo');
    var components = asyncapi.hasComponents() && asyncapi.components();
    var messages = components && components.messages();
    var schemas = components && components.schemas();
    var Operations = exports.OperationsList;
    if (showOperations === 'bySpecTags') {
        Operations = exports.OperationsByRootTags;
    }
    else if (showOperations === 'byOperationsTags') {
        Operations = exports.OperationsByOperationsTags;
    }
    var messagesList = messages && Object.keys(messages).length > 0 && (react_1.default.createElement("li", { className: "mb-3 mt-9" },
        react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#messages", onClick: function () { return setShowSidebar(false); } }, "Messages"),
        react_1.default.createElement("ul", { className: "text-sm mt-2" }, Object.entries(messages).map(function (_a) {
            var messageName = _a[0], message = _a[1];
            return (react_1.default.createElement("li", { key: messageName },
                react_1.default.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#message-".concat(messageName), onClick: function () { return setShowSidebar(false); } },
                    react_1.default.createElement("div", { className: "break-all inline-block" }, message.uid()))));
        }))));
    var schemasList = schemas && Object.keys(schemas).length > 0 && (react_1.default.createElement("li", { className: "mb-3 mt-9" },
        react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#schemas", onClick: function () { return setShowSidebar(false); } }, "Schemas"),
        react_1.default.createElement("ul", { className: "text-sm mt-2" }, Object.keys(schemas).map(function (schemaName) { return (react_1.default.createElement("li", { key: schemaName },
            react_1.default.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#schema-".concat(schemaName), onClick: function () { return setShowSidebar(false); } },
                react_1.default.createElement("div", { className: "break-all inline-block" }, schemaName)))); }))));
    return (react_1.default.createElement(SidebarContext.Provider, { value: { setShowSidebar: setShowSidebar } },
        react_1.default.createElement("div", { className: "burger-menu rounded-full h-16 w-16 bg-white fixed bottom-16 right-8 flex items-center justify-center z-30 cursor-pointer shadow-md bg-teal-500", onClick: function () { return setShowSidebar(function (prev) { return !prev; }); }, "data-lol": showSidebar },
            react_1.default.createElement("svg", { viewBox: "0 0 100 70", width: "40", height: "30", className: "fill-current text-gray-200" },
                react_1.default.createElement("rect", { width: "100", height: "10" }),
                react_1.default.createElement("rect", { y: "30", width: "100", height: "10" }),
                react_1.default.createElement("rect", { y: "60", width: "100", height: "10" }))),
        react_1.default.createElement("div", { className: "".concat(showSidebar ? 'block fixed w-full' : 'hidden', " sidebar relative w-64 max-h-screen h-full bg-gray-200 shadow z-20") },
            react_1.default.createElement("div", { className: "".concat(showSidebar ? 'w-full' : '', " block fixed max-h-screen h-full font-sans px-4 pt-8 pb-16 overflow-y-auto bg-gray-200") },
                react_1.default.createElement("div", { className: "sidebar--content" },
                    react_1.default.createElement("div", null, logo ? (react_1.default.createElement("img", { src: logo, alt: "".concat(info.title(), " logo, ").concat(info.version(), " version") })) : (react_1.default.createElement("h1", { className: "text-2xl font-light" },
                        info.title(),
                        " ",
                        info.version()))),
                    react_1.default.createElement("ul", { className: "text-sm mt-10 relative" },
                        react_1.default.createElement("li", { className: "mb-3" },
                            react_1.default.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#introduction", onClick: function () { return setShowSidebar(false); } }, "Introduction")),
                        asyncapi.hasServers() && (react_1.default.createElement("li", { className: "mb-3" },
                            react_1.default.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#servers", onClick: function () { return setShowSidebar(false); } }, "Servers"))),
                        asyncapi.hasChannels() && (react_1.default.createElement(react_1.default.Fragment, null,
                            react_1.default.createElement("li", { className: "mb-3 mt-9" },
                                react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#operations", onClick: function () { return setShowSidebar(false); } }, "Operations"),
                                react_1.default.createElement(Operations, null)),
                            messagesList,
                            schemasList))))))));
};
exports.Sidebar = Sidebar;
var OperationsList = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var channels = asyncapi.channels();
    var operationsList = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish()) {
            operationsList.push(react_1.default.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe()) {
            operationsList.push(react_1.default.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return react_1.default.createElement("ul", { className: "text-sm mt-2" }, operationsList);
};
exports.OperationsList = OperationsList;
var OperationsByRootTags = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var channels = asyncapi.channels();
    var tags = asyncapi.tags();
    var taggedOperations = function (tag) {
        var operationsList = [];
        Object.entries(channels).forEach(function (_a) {
            var channelName = _a[0], channel = _a[1];
            if (channel.hasPublish() &&
                helpers_1.SpecificationHelpers.containTags(channel.publish(), tag)) {
                operationsList.push(react_1.default.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
            }
            if (channel.hasSubscribe() &&
                helpers_1.SpecificationHelpers.containTags(channel.subscribe(), tag)) {
                operationsList.push(react_1.default.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
            }
        });
        return operationsList;
    };
    var untaggedOperations = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish() &&
            (!channel.publish().hasTags() ||
                !helpers_1.SpecificationHelpers.containTags(channel.publish(), tags))) {
            untaggedOperations.push(react_1.default.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe() &&
            (!channel.subscribe().hasTags() ||
                !helpers_1.SpecificationHelpers.containTags(channel.subscribe(), tags))) {
            untaggedOperations.push(react_1.default.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("ul", null,
            tags &&
                tags.map(function (tag) {
                    var ops = taggedOperations(tag);
                    return (ops.length > 0 && (react_1.default.createElement("li", { key: tag.name() },
                        react_1.default.createElement(OperationsByTagItem, { tagName: tag.name() }, taggedOperations(tag)))));
                }),
            untaggedOperations.length > 0 && (react_1.default.createElement("li", null,
                react_1.default.createElement(OperationsByTagItem, { tagName: "Untagged" }, untaggedOperations))))));
};
exports.OperationsByRootTags = OperationsByRootTags;
var OperationsByOperationsTags = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var channels = asyncapi.channels();
    var operationsTags = helpers_1.SpecificationHelpers.operationsTags(asyncapi);
    var taggedOperations = function (tag) {
        var operationsList = [];
        Object.entries(channels).forEach(function (_a) {
            var channelName = _a[0], channel = _a[1];
            if (channel.hasPublish() &&
                helpers_1.SpecificationHelpers.containTags(channel.publish(), tag)) {
                operationsList.push(react_1.default.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
            }
            if (channel.hasSubscribe() &&
                helpers_1.SpecificationHelpers.containTags(channel.subscribe(), tag)) {
                operationsList.push(react_1.default.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
            }
        });
        return operationsList;
    };
    var untaggedOperations = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish() &&
            (!channel.publish().hasTags() ||
                !helpers_1.SpecificationHelpers.containTags(channel.publish(), operationsTags))) {
            untaggedOperations.push(react_1.default.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe() &&
            (!channel.subscribe().hasTags() ||
                !helpers_1.SpecificationHelpers.containTags(channel.subscribe(), operationsTags))) {
            untaggedOperations.push(react_1.default.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("ul", null,
            operationsTags &&
                operationsTags.map(function (tag) {
                    var ops = taggedOperations(tag);
                    return (ops.length > 0 && (react_1.default.createElement("li", { key: tag.name() },
                        react_1.default.createElement(OperationsByTagItem, { tagName: tag.name() }, taggedOperations(tag)))));
                }),
            untaggedOperations.length > 0 && (react_1.default.createElement("li", null,
                react_1.default.createElement(OperationsByTagItem, { tagName: "Untagged" }, untaggedOperations))))));
};
exports.OperationsByOperationsTags = OperationsByOperationsTags;
var OperationsByTagItem = function (_a) {
    var tagName = _a.tagName, children = _a.children;
    var _b = (0, react_1.useState)(false), expand = _b[0], setExpand = _b[1];
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(components_1.CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                className: expand ? '-rotate-180' : '-rotate-90',
            } },
            react_1.default.createElement("span", { className: "text-sm inline-block mt-1 font-extralight" }, tagName)),
        react_1.default.createElement("ul", { className: "".concat(expand ? 'block' : 'hidden', " text-sm mt-2 font-light") }, children)));
};
var OperationsPubItem = function (_a) {
    var channelName = _a.channelName;
    var setShowSidebar = (0, react_1.useContext)(SidebarContext).setShowSidebar;
    return (react_1.default.createElement("li", null,
        react_1.default.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#operation-publish-".concat(channelName), onClick: function () { return setShowSidebar(false); } },
            react_1.default.createElement("span", { className: "bg-blue-600 font-bold h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs", title: "Publish" }, "Pub"),
            react_1.default.createElement("span", { className: "break-all inline-block" }, channelName))));
};
var OperationsSubItem = function (_a) {
    var channelName = _a.channelName;
    var setShowSidebar = (0, react_1.useContext)(SidebarContext).setShowSidebar;
    return (react_1.default.createElement("li", null,
        react_1.default.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#operation-subscribe-".concat(channelName), onClick: function () { return setShowSidebar(false); } },
            react_1.default.createElement("span", { className: "bg-green-600 font-bold h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs", title: "Subscribe" }, "SUB"),
            react_1.default.createElement("span", { className: "break-all inline-block" }, channelName))));
};
//# sourceMappingURL=Sidebar.js.map