"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpecificationHelpers = void 0;
var asyncapi_1 = __importDefault(require("@asyncapi/parser/lib/models/asyncapi"));
var SpecificationHelpers = (function () {
    function SpecificationHelpers() {
    }
    SpecificationHelpers.retrieveParsedSpec = function (schema) {
        if (!schema) {
            return undefined;
        }
        if (schema.constructor && schema.constructor.name === 'AsyncAPIDocument') {
            return schema;
        }
        if (typeof schema.version === 'function' &&
            schema._json &&
            schema._json.asyncapi) {
            return schema;
        }
        if (typeof schema === 'string') {
            try {
                schema = JSON.parse(schema);
            }
            catch (e) {
                return undefined;
            }
        }
        if (typeof schema === 'object' && schema['x-parser-spec-parsed'] === true) {
            if (schema['x-parser-spec-stringified'] === true) {
                return asyncapi_1.default.parse(schema);
            }
            return new asyncapi_1.default(schema);
        }
        return undefined;
    };
    SpecificationHelpers.containTags = function (schema, tags) {
        var tagsToCheck = typeof schema.tags === 'function' ? schema.tags() : undefined;
        if (tagsToCheck === undefined || !Array.isArray(tagsToCheck)) {
            return false;
        }
        tags = Array.isArray(tags) ? tags : [tags];
        return tagsToCheck.some(function (tag) {
            return tags.some(function (t) { return t.name() === tag.name(); });
        });
    };
    SpecificationHelpers.operationsTags = function (spec) {
        var tags = new Map();
        Object.entries(spec.channels()).forEach(function (_a) {
            var _ = _a[0], channel = _a[1];
            var publish = channel.publish();
            if (publish && publish.hasTags()) {
                publish.tags().forEach(function (tag) { return tags.set(tag.name(), tag); });
            }
            var subscribe = channel.subscribe();
            if (subscribe && subscribe.hasTags()) {
                subscribe.tags().forEach(function (tag) { return tags.set(tag.name(), tag); });
            }
        });
        return Array.from(tags.values());
    };
    return SpecificationHelpers;
}());
exports.SpecificationHelpers = SpecificationHelpers;
//# sourceMappingURL=specification.js.map