import React, { useState } from 'react';
import useResizeObserver from 'use-resize-observer';
import { Sidebar } from '../Sidebar/Sidebar';
import { Info } from '../Info/Info';
import { Servers } from '../Servers/Servers';
import { Operations } from '../Operations/Operations';
import { Messages } from '../Messages/Messages';
import { Schemas } from '../Schemas/Schemas';
import { Error } from '../Error/Error';
import { SpecificationContext, ConfigContext } from '../../contexts';
var AsyncApiLayout = function (_a) {
    var _b, _c, _d, _e, _f, _g, _h;
    var asyncapi = _a.asyncapi, config = _a.config, _j = _a.error, error = _j === void 0 ? null : _j;
    var _k = useState('container:xl'), observerClassName = _k[0], setObserverClassName = _k[1];
    var ref = useResizeObserver({
        onResize: function (_a) {
            var width = _a.width;
            requestAnimationFrame(function () {
                if (width === undefined) {
                    return;
                }
                var possibleClassName = width <= 1280 ? 'container:xl' : 'container:base';
                if (possibleClassName !== observerClassName) {
                    setObserverClassName(possibleClassName);
                }
            });
        },
    }).ref;
    return (React.createElement(ConfigContext.Provider, { value: config },
        React.createElement(SpecificationContext.Provider, { value: asyncapi },
            React.createElement("section", { className: "aui-root" },
                React.createElement("div", { className: "".concat(observerClassName, " relative md:flex bg-white leading-normal"), id: config.schemaID || undefined, ref: ref },
                    ((_b = config.show) === null || _b === void 0 ? void 0 : _b.sidebar) && React.createElement(Sidebar, { config: config.sidebar }),
                    React.createElement("div", { className: "panel--center relative py-8 flex-1" },
                        React.createElement("div", { className: "relative z-10" },
                            ((_c = config.show) === null || _c === void 0 ? void 0 : _c.errors) && error && React.createElement(Error, { error: error }),
                            ((_d = config.show) === null || _d === void 0 ? void 0 : _d.info) && React.createElement(Info, null),
                            ((_e = config.show) === null || _e === void 0 ? void 0 : _e.servers) && React.createElement(Servers, null),
                            ((_f = config.show) === null || _f === void 0 ? void 0 : _f.operations) && React.createElement(Operations, null),
                            ((_g = config.show) === null || _g === void 0 ? void 0 : _g.messages) && React.createElement(Messages, null),
                            ((_h = config.show) === null || _h === void 0 ? void 0 : _h.schemas) && React.createElement(Schemas, null)),
                        React.createElement("div", { className: "panel--right absolute top-0 right-0 h-full bg-gray-800" })))))));
};
export default AsyncApiLayout;
//# sourceMappingURL=Layout.js.map