import React, { useState } from 'react';
import { CollapseButton, JSONSnippet } from '../../components';
import { MessageHelpers } from '../../helpers/message';
export var MessageExample = function (_a) {
    var message = _a.message;
    if (!message) {
        return null;
    }
    var payload = message.payload();
    var headers = message.headers();
    return (React.createElement("div", { className: "bg-gray-800 px-8 py-4 mt-4 -mx-8 2xl:mx-0 2xl:px-4 2xl:rounded examples" },
        React.createElement("h4", { className: "text-white text-lg" }, "Examples"),
        payload && (React.createElement(Example, { type: "Payload", schema: payload, examples: MessageHelpers.getPayloadExamples(message) })),
        headers && (React.createElement(Example, { type: "Headers", schema: headers, examples: MessageHelpers.getHeadersExamples(message) }))));
};
export var Example = function (_a) {
    var _b = _a.type, type = _b === void 0 ? 'Payload' : _b, schema = _a.schema, _c = _a.examples, examples = _c === void 0 ? [] : _c;
    var _d = useState(false), expand = _d[0], setExpand = _d[1];
    return (React.createElement("div", { className: "mt-4" },
        React.createElement("div", null,
            React.createElement(CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                    className: "fill-current text-gray-200 ".concat(expand ? '-rotate-180' : '-rotate-90'),
                } },
                React.createElement("span", { className: "px-2 py-1 mr-2 text-gray-200 text-sm border rounded focus:outline-none" }, type))),
        React.createElement("div", { className: expand ? 'block' : 'hidden' }, examples && examples.length > 0 ? (React.createElement("ul", null, examples.map(function (example, idx) { return (React.createElement("li", { className: "mt-4", key: idx },
            React.createElement("h5", { className: "text-xs font-bold text-gray-500" }, example.name
                ? "#".concat(idx + 1, " Example - ").concat(example.name)
                : "#".concat(idx + 1, " Example")),
            example.summary && (React.createElement("p", { className: "text-xs font-bold text-gray-500" }, example.summary)),
            React.createElement("div", { className: "mt-1" },
                React.createElement(JSONSnippet, { snippet: MessageHelpers.sanitizeExample(example.example) })))); }))) : (React.createElement("div", { className: "mt-4" },
            React.createElement(JSONSnippet, { snippet: MessageHelpers.generateExample(schema.json()) }),
            React.createElement("h6", { className: "text-xs font-bold text-gray-600 italic mt-2" }, "This example has been generated automatically."))))));
};
//# sourceMappingURL=MessageExample.js.map