import React from 'react';
import { Href, Markdown } from '../../components';
import { useSpec } from '../../contexts';
import { ServerHelpers } from '../../helpers';
export var ServerSecurity = function (_a) {
    var _b = _a.serverRequirements, serverRequirements = _b === void 0 ? [] : _b, _c = _a.protocol, protocol = _c === void 0 ? '' : _c;
    var asyncapi = useSpec();
    var securitySchemes = asyncapi.hasComponents() && asyncapi.components().securitySchemes();
    var renderedServerSecurities;
    if (!serverRequirements ||
        !serverRequirements.length ||
        !securitySchemes ||
        !Object.keys(securitySchemes).length) {
        if (protocol === 'kafka' || protocol === 'kafka-secure') {
            renderedServerSecurities = (React.createElement(ServerSecurityItem, { protocol: protocol, securitySchema: null }));
        }
    }
    else {
        var serverSecurities = serverRequirements
            .map(function (requirement) {
            var def = securitySchemes[Object.keys(requirement.json())[0]];
            if (!def) {
                return null;
            }
            return (React.createElement(ServerSecurityItem, { protocol: protocol, securitySchema: def, key: def.type() }));
        })
            .filter(Boolean);
        renderedServerSecurities = (React.createElement("ul", null, serverSecurities.map(function (security, idx) { return (React.createElement("li", { className: "mt-2", key: idx }, security)); })));
    }
    if (!renderedServerSecurities) {
        return null;
    }
    return (React.createElement("div", { className: "text-sm mt-4" },
        React.createElement("h5", { className: "text-gray-700 text-base" }, "Security:"),
        renderedServerSecurities));
};
function collectSecuritySchemas(securitySchema) {
    var schemas = [];
    if (securitySchema) {
        if (securitySchema.name()) {
            schemas.push(React.createElement("span", null,
                "Name: ",
                securitySchema.name()));
        }
        if (securitySchema.in()) {
            schemas.push(React.createElement("span", null,
                "In: ",
                securitySchema.in()));
        }
        if (securitySchema.scheme()) {
            schemas.push(React.createElement("span", null,
                "Scheme: ",
                securitySchema.scheme()));
        }
        if (securitySchema.bearerFormat()) {
            schemas.push(React.createElement("span", null,
                "Bearer format: ",
                securitySchema.bearerFormat()));
        }
        if (securitySchema.openIdConnectUrl()) {
            schemas.push(React.createElement(Href, { href: securitySchema.openIdConnectUrl(), className: "underline" }, "Connect URL"));
        }
    }
    return schemas;
}
var ServerSecurityItem = function (_a) {
    var securitySchema = _a.securitySchema, protocol = _a.protocol;
    var schemas = collectSecuritySchemas(securitySchema);
    var renderedKafkaSecurity;
    if (['kafka', 'kafka-secure'].includes(protocol)) {
        var _b = ServerHelpers.getKafkaSecurity(protocol, securitySchema), securityProtocol = _b.securityProtocol, saslMechanism = _b.saslMechanism;
        renderedKafkaSecurity = (React.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded" },
            securityProtocol && (React.createElement("div", { className: "mt-1" },
                React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "security.protocol:"),
                React.createElement("span", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, securityProtocol))),
            saslMechanism && (React.createElement("div", { className: "mt-1" },
                React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "sasl.mechanism:"),
                React.createElement("span", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1" }, saslMechanism)))));
    }
    var flows = securitySchema && securitySchema.flows();
    var renderedFlows = flows &&
        Object.entries(flows).map(function (_a) {
            var flowName = _a[0], flow = _a[1];
            var authorizationUrl = flow.authorizationUrl();
            var tokenUrl = flow.tokenUrl();
            var refreshUrl = flow.refreshUrl();
            var scopes = flow.scopes();
            return (React.createElement("div", { className: "px-4 py-2 ml-2 mb-2 border border-gray-400 bg-gray-100 rounded", key: flowName },
                React.createElement("div", null,
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Flow:"),
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, ServerHelpers.flowName(flowName))),
                authorizationUrl && (React.createElement("div", { className: "mt-1" },
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Auth URL:"),
                    React.createElement(Href, { href: authorizationUrl, className: "underline" }, authorizationUrl))),
                tokenUrl && (React.createElement("div", { className: "mt-1" },
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Token URL:"),
                    React.createElement(Href, { href: tokenUrl, className: "underline" }, tokenUrl))),
                refreshUrl && (React.createElement("div", { className: "mt-1" },
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Refresh URL:"),
                    React.createElement(Href, { href: refreshUrl, className: "underline" }, refreshUrl))),
                scopes && (React.createElement("div", { className: "mt-1" },
                    React.createElement("span", { className: "text-xs font-bold text-gray-600 mt-1 mr-1 uppercase" }, "Scopes:"),
                    React.createElement("ul", { className: "inline-block" }, scopes &&
                        Object.entries(scopes).map(function (_a) {
                            var scopeName = _a[0], scopeDesc = _a[1];
                            return (React.createElement("li", { className: "inline-block font-bold no-underline bg-indigo-400 text-white text-xs rounded py-0 px-1 ml-1", title: scopeDesc, key: scopeName }, scopeName));
                        }))))));
        });
    return (React.createElement("div", null,
        securitySchema && schemas && (React.createElement("div", null,
            React.createElement("span", null,
                ServerHelpers.securityType(securitySchema.type()),
                schemas.length > 0 && (React.createElement("ul", { className: "inline-block ml-2" }, schemas.map(function (schema, idx) { return (React.createElement("li", { className: "inline-block font-bold no-underline bg-blue-400 text-white text-xs uppercase rounded px-2 py-0 ml-1", key: idx }, schema)); })))))),
        securitySchema && securitySchema.hasDescription() && (React.createElement("div", null,
            React.createElement(Markdown, null, securitySchema.description()))),
        renderedFlows && renderedFlows.length > 0 && (React.createElement("ul", { className: "my-2" },
            React.createElement("li", null, renderedFlows))),
        renderedKafkaSecurity && React.createElement("div", null, renderedKafkaSecurity)));
};
//# sourceMappingURL=ServerSecurity.js.map