"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var use_resize_observer_1 = __importDefault(require("use-resize-observer"));
var Sidebar_1 = require("../Sidebar/Sidebar");
var Info_1 = require("../Info/Info");
var Servers_1 = require("../Servers/Servers");
var Operations_1 = require("../Operations/Operations");
var Messages_1 = require("../Messages/Messages");
var Schemas_1 = require("../Schemas/Schemas");
var Error_1 = require("../Error/Error");
var contexts_1 = require("../../contexts");
var AsyncApiLayout = function (_a) {
    var _b, _c, _d, _e, _f, _g, _h;
    var asyncapi = _a.asyncapi, config = _a.config, _j = _a.error, error = _j === void 0 ? null : _j;
    var _k = (0, react_1.useState)('container:xl'), observerClassName = _k[0], setObserverClassName = _k[1];
    var ref = (0, use_resize_observer_1.default)({
        onResize: function (_a) {
            var width = _a.width;
            requestAnimationFrame(function () {
                if (width === undefined) {
                    return;
                }
                var possibleClassName = width <= 1280 ? 'container:xl' : 'container:base';
                if (possibleClassName !== observerClassName) {
                    setObserverClassName(possibleClassName);
                }
            });
        },
    }).ref;
    return (react_1.default.createElement(contexts_1.ConfigContext.Provider, { value: config },
        react_1.default.createElement(contexts_1.SpecificationContext.Provider, { value: asyncapi },
            react_1.default.createElement("section", { className: "aui-root" },
                react_1.default.createElement("div", { className: "".concat(observerClassName, " relative md:flex bg-white leading-normal"), id: config.schemaID || undefined, ref: ref },
                    ((_b = config.show) === null || _b === void 0 ? void 0 : _b.sidebar) && react_1.default.createElement(Sidebar_1.Sidebar, { config: config.sidebar }),
                    react_1.default.createElement("div", { className: "panel--center relative py-8 flex-1" },
                        react_1.default.createElement("div", { className: "relative z-10" },
                            ((_c = config.show) === null || _c === void 0 ? void 0 : _c.errors) && error && react_1.default.createElement(Error_1.Error, { error: error }),
                            ((_d = config.show) === null || _d === void 0 ? void 0 : _d.info) && react_1.default.createElement(Info_1.Info, null),
                            ((_e = config.show) === null || _e === void 0 ? void 0 : _e.servers) && react_1.default.createElement(Servers_1.Servers, null),
                            ((_f = config.show) === null || _f === void 0 ? void 0 : _f.operations) && react_1.default.createElement(Operations_1.Operations, null),
                            ((_g = config.show) === null || _g === void 0 ? void 0 : _g.messages) && react_1.default.createElement(Messages_1.Messages, null),
                            ((_h = config.show) === null || _h === void 0 ? void 0 : _h.schemas) && react_1.default.createElement(Schemas_1.Schemas, null)),
                        react_1.default.createElement("div", { className: "panel--right absolute top-0 right-0 h-full bg-gray-800" })))))));
};
exports.default = AsyncApiLayout;
//# sourceMappingURL=Layout.js.map