import React, { useState, useContext } from 'react';
import { CollapseButton } from '../../components';
import { useConfig, useSpec } from '../../contexts';
import { SpecificationHelpers } from '../../helpers';
import { PUBLISH_LABEL_DEFAULT_TEXT, SUBSCRIBE_LABEL_DEFAULT_TEXT, } from '../../constants';
var SidebarContext = React.createContext({
    setShowSidebar: function (value) { return value; },
});
export var Sidebar = function (_a) {
    var config = _a.config;
    var _b = useState(false), showSidebar = _b[0], setShowSidebar = _b[1];
    var showOperations = (config === null || config === void 0 ? void 0 : config.showOperations) || 'byDefault';
    var asyncapi = useSpec();
    var info = asyncapi.info();
    var logo = info.ext('x-logo');
    var components = asyncapi.hasComponents() && asyncapi.components();
    var messages = components && components.messages();
    var schemas = components && components.schemas();
    var Operations = OperationsList;
    if (showOperations === 'bySpecTags') {
        Operations = OperationsByRootTags;
    }
    else if (showOperations === 'byOperationsTags') {
        Operations = OperationsByOperationsTags;
    }
    var messagesList = messages && Object.keys(messages).length > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#messages", onClick: function () { return setShowSidebar(false); } }, "Messages"),
        React.createElement("ul", { className: "text-sm mt-2" }, Object.entries(messages).map(function (_a) {
            var messageName = _a[0], message = _a[1];
            return (React.createElement("li", { key: messageName },
                React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#message-".concat(messageName), onClick: function () { return setShowSidebar(false); } },
                    React.createElement("div", { className: "break-all inline-block" }, message.uid()))));
        }))));
    var schemasList = schemas && Object.keys(schemas).length > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#schemas", onClick: function () { return setShowSidebar(false); } }, "Schemas"),
        React.createElement("ul", { className: "text-sm mt-2" }, Object.keys(schemas).map(function (schemaName) { return (React.createElement("li", { key: schemaName },
            React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#schema-".concat(schemaName), onClick: function () { return setShowSidebar(false); } },
                React.createElement("div", { className: "break-all inline-block" }, schemaName)))); }))));
    return (React.createElement(SidebarContext.Provider, { value: { setShowSidebar: setShowSidebar } },
        React.createElement("div", { className: "burger-menu rounded-full h-16 w-16 bg-white fixed bottom-16 right-8 flex items-center justify-center z-30 cursor-pointer shadow-md bg-teal-500", onClick: function () { return setShowSidebar(function (prev) { return !prev; }); }, "data-lol": showSidebar },
            React.createElement("svg", { viewBox: "0 0 100 70", width: "40", height: "30", className: "fill-current text-gray-200" },
                React.createElement("rect", { width: "100", height: "10" }),
                React.createElement("rect", { y: "30", width: "100", height: "10" }),
                React.createElement("rect", { y: "60", width: "100", height: "10" }))),
        React.createElement("div", { className: "".concat(showSidebar ? 'block fixed w-full' : 'hidden', " sidebar relative w-64 max-h-screen h-full bg-gray-200 shadow z-20") },
            React.createElement("div", { className: "".concat(showSidebar ? 'w-full' : '', " block fixed max-h-screen h-full font-sans px-4 pt-8 pb-16 overflow-y-auto bg-gray-200") },
                React.createElement("div", { className: "sidebar--content" },
                    React.createElement("div", null, logo ? (React.createElement("img", { src: logo, alt: "".concat(info.title(), " logo, ").concat(info.version(), " version") })) : (React.createElement("h1", { className: "text-2xl font-light" },
                        info.title(),
                        " ",
                        info.version()))),
                    React.createElement("ul", { className: "text-sm mt-10 relative" },
                        React.createElement("li", { className: "mb-3" },
                            React.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#introduction", onClick: function () { return setShowSidebar(false); } }, "Introduction")),
                        asyncapi.hasServers() && (React.createElement("li", { className: "mb-3" },
                            React.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#servers", onClick: function () { return setShowSidebar(false); } }, "Servers"))),
                        asyncapi.hasChannels() && (React.createElement(React.Fragment, null,
                            React.createElement("li", { className: "mb-3 mt-9" },
                                React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#operations", onClick: function () { return setShowSidebar(false); } }, "Operations"),
                                React.createElement(Operations, null)),
                            messagesList,
                            schemasList))))))));
};
export var OperationsList = function () {
    var asyncapi = useSpec();
    var channels = asyncapi.channels();
    var operationsList = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish()) {
            operationsList.push(React.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe()) {
            operationsList.push(React.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return React.createElement("ul", { className: "text-sm mt-2" }, operationsList);
};
export var OperationsByRootTags = function () {
    var asyncapi = useSpec();
    var channels = asyncapi.channels();
    var tags = asyncapi.tags();
    var taggedOperations = function (tag) {
        var operationsList = [];
        Object.entries(channels).forEach(function (_a) {
            var channelName = _a[0], channel = _a[1];
            if (channel.hasPublish() &&
                SpecificationHelpers.containTags(channel.publish(), tag)) {
                operationsList.push(React.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
            }
            if (channel.hasSubscribe() &&
                SpecificationHelpers.containTags(channel.subscribe(), tag)) {
                operationsList.push(React.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
            }
        });
        return operationsList;
    };
    var untaggedOperations = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish() &&
            (!channel.publish().hasTags() ||
                !SpecificationHelpers.containTags(channel.publish(), tags))) {
            untaggedOperations.push(React.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe() &&
            (!channel.subscribe().hasTags() ||
                !SpecificationHelpers.containTags(channel.subscribe(), tags))) {
            untaggedOperations.push(React.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return (React.createElement("div", null,
        React.createElement("ul", null,
            tags &&
                tags.map(function (tag) {
                    var ops = taggedOperations(tag);
                    return (ops.length > 0 && (React.createElement("li", { key: tag.name() },
                        React.createElement(OperationsByTagItem, { tagName: tag.name() }, taggedOperations(tag)))));
                }),
            untaggedOperations.length > 0 && (React.createElement("li", null,
                React.createElement(OperationsByTagItem, { tagName: "Untagged" }, untaggedOperations))))));
};
export var OperationsByOperationsTags = function () {
    var asyncapi = useSpec();
    var channels = asyncapi.channels();
    var operationsTags = SpecificationHelpers.operationsTags(asyncapi);
    var taggedOperations = function (tag) {
        var operationsList = [];
        Object.entries(channels).forEach(function (_a) {
            var channelName = _a[0], channel = _a[1];
            if (channel.hasPublish() &&
                SpecificationHelpers.containTags(channel.publish(), tag)) {
                operationsList.push(React.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
            }
            if (channel.hasSubscribe() &&
                SpecificationHelpers.containTags(channel.subscribe(), tag)) {
                operationsList.push(React.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
            }
        });
        return operationsList;
    };
    var untaggedOperations = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish() &&
            (!channel.publish().hasTags() ||
                !SpecificationHelpers.containTags(channel.publish(), operationsTags))) {
            untaggedOperations.push(React.createElement(OperationsPubItem, { channelName: channelName, key: "pub-".concat(channelName) }));
        }
        if (channel.hasSubscribe() &&
            (!channel.subscribe().hasTags() ||
                !SpecificationHelpers.containTags(channel.subscribe(), operationsTags))) {
            untaggedOperations.push(React.createElement(OperationsSubItem, { channelName: channelName, key: "sub-".concat(channelName) }));
        }
    });
    return (React.createElement("div", null,
        React.createElement("ul", null,
            operationsTags &&
                operationsTags.map(function (tag) {
                    var ops = taggedOperations(tag);
                    return (ops.length > 0 && (React.createElement("li", { key: tag.name() },
                        React.createElement(OperationsByTagItem, { tagName: tag.name() }, taggedOperations(tag)))));
                }),
            untaggedOperations.length > 0 && (React.createElement("li", null,
                React.createElement(OperationsByTagItem, { tagName: "Untagged" }, untaggedOperations))))));
};
var OperationsByTagItem = function (_a) {
    var tagName = _a.tagName, children = _a.children;
    var _b = useState(false), expand = _b[0], setExpand = _b[1];
    return (React.createElement("div", null,
        React.createElement(CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                className: expand ? '-rotate-180' : '-rotate-90',
            } },
            React.createElement("span", { className: "text-sm inline-block mt-1 font-extralight" }, tagName)),
        React.createElement("ul", { className: "".concat(expand ? 'block' : 'hidden', " text-sm mt-2 font-light") }, children)));
};
var OperationsPubItem = function (_a) {
    var channelName = _a.channelName;
    var config = useConfig();
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    return (React.createElement("li", null,
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#operation-publish-".concat(channelName), onClick: function () { return setShowSidebar(false); } },
            React.createElement("span", { className: "bg-blue-600 font-bold h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs", title: "Publish" }, config.publishLabel || PUBLISH_LABEL_DEFAULT_TEXT),
            React.createElement("span", { className: "break-all inline-block" }, channelName))));
};
var OperationsSubItem = function (_a) {
    var channelName = _a.channelName;
    var config = useConfig();
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    return (React.createElement("li", null,
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#operation-subscribe-".concat(channelName), onClick: function () { return setShowSidebar(false); } },
            React.createElement("span", { className: "bg-green-600 font-bold h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs", title: "Subscribe" }, config.subscribeLabel || SUBSCRIBE_LABEL_DEFAULT_TEXT),
            React.createElement("span", { className: "break-all inline-block" }, channelName))));
};
//# sourceMappingURL=Sidebar.js.map