import React, { useState, useEffect } from 'react';
import { CollapseButton, JSONSnippet } from '../../components';
import { MessageHelpers } from '../../helpers/message';
import { useConfig } from '../../contexts';
export var MessageExample = function (_a) {
    var message = _a.message;
    if (!message) {
        return null;
    }
    var payload = message.payload();
    var headers = message.headers();
    return (React.createElement("div", { className: "bg-gray-800 px-8 py-4 mt-4 -mx-8 2xl:mx-0 2xl:px-4 2xl:rounded examples" },
        React.createElement("h4", { className: "text-white text-lg" }, "Examples"),
        payload && (React.createElement(Example, { type: "Payload", schema: payload, examples: MessageHelpers.getPayloadExamples(message) })),
        headers && (React.createElement(Example, { type: "Headers", schema: headers, examples: MessageHelpers.getHeadersExamples(message) }))));
};
export var Example = function (_a) {
    var _b = _a.type, type = _b === void 0 ? 'Payload' : _b, schema = _a.schema, _c = _a.examples, examples = _c === void 0 ? [] : _c;
    var config = useConfig();
    var _d = useState((config && config.expand && config.expand.messageExamples) || false), expanded = _d[0], setExpanded = _d[1];
    useEffect(function () {
        setExpanded((config && config.expand && config.expand.messageExamples) || false);
    }, [config.expand]);
    return (React.createElement("div", { className: "mt-4" },
        React.createElement("div", null,
            React.createElement(CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded, chevronProps: {
                    className: 'fill-current text-gray-200',
                } },
                React.createElement("span", { className: "inline-block w-20 py-0.5 mr-1 text-gray-200 text-sm border text-center rounded focus:outline-none" }, type))),
        React.createElement("div", { className: expanded ? 'block' : 'hidden' }, examples && examples.length > 0 ? (React.createElement("ul", null, examples.map(function (example, idx) { return (React.createElement("li", { className: "mt-4", key: idx },
            React.createElement("h5", { className: "text-xs font-bold text-gray-500" }, example.name
                ? "#".concat(idx + 1, " Example - ").concat(example.name)
                : "#".concat(idx + 1, " Example")),
            example.summary && (React.createElement("p", { className: "text-xs font-bold text-gray-500" }, example.summary)),
            React.createElement("div", { className: "mt-1" },
                React.createElement(JSONSnippet, { snippet: MessageHelpers.sanitizeExample(example.example) })))); }))) : (React.createElement("div", { className: "mt-4" },
            React.createElement(JSONSnippet, { snippet: MessageHelpers.generateExample(schema.json()) }),
            React.createElement("h6", { className: "text-xs font-bold text-gray-600 italic mt-2" }, "This example has been generated automatically."))))));
};
//# sourceMappingURL=MessageExample.js.map