"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const asynciterator_1 = require("asynciterator");
/**
 * A {@link TransformIterator} that allows the source to be set through a lazy Promise.
 * The provided getter will only be called from the moment that this proxy iterator is being read.
 *
 * Rejections of the promise will be emitted as error event.
 */
class PromiseProxyIterator extends asynciterator_1.TransformIterator {
    constructor(sourceGetter, options) {
        super(options || { autoStart: false });
        this.sourceGetter = sourceGetter;
    }
    _read(count, done) {
        if (!this.source) {
            this.sourceGetter().then((source) => {
                this.source = source;
                super._read(count, done);
            }).catch((error) => this.emit('error', error));
        }
        else {
            super._read(count, done);
        }
    }
}
exports.PromiseProxyIterator = PromiseProxyIterator;
//# sourceMappingURL=PromiseProxyIterator.js.map