import { AsyncIterator, BufferedIterator, BufferedIteratorOptions } from "asynciterator";
/**
 * An iterator that takes elements from a given array or iterator of iterators in a round-robin manner.
 *
 * Based on LDF client's UnionIterator:
 * https://github.com/LinkedDataFragments/Client.js/blob/master/lib/sparql/UnionIterator.js
 */
export declare class RoundRobinUnionIterator<T> extends BufferedIterator<T> {
    protected readonly sourceIterator: AsyncIterator<AsyncIterator<T>>;
    protected readonly sources: AsyncIterator<T>[];
    protected sourcedEnded: boolean;
    protected currentSource: number;
    protected listenersAttached: boolean;
    constructor(sources: AsyncIterator<AsyncIterator<T>> | AsyncIterator<T>[], options?: BufferedIteratorOptions);
    _read(count: number, done: () => void): void;
}
