import { AsyncIterator, BufferedIterator } from "asynciterator";
import { AsyncReiterable } from "./AsyncReiterable";
/**
 * An {@link AsyncReiterable} that is backed by an array.
 */
export declare class AsyncReiterableArray<T> implements AsyncReiterable<T> {
    private readonly array;
    private readonly iterators;
    protected constructor(array: T[], terminate?: boolean);
    /**
     * Create a new {@link AsyncReiterableArray} with the given data elements
     * that will be ended.
     * @param {T[]} array An array of data elements.
     * @return {AsyncReiterableArray<T>} A new ended {@link AsyncReiterableArray} with the given data elements.
     */
    static fromFixedData<T>(array: T[]): AsyncReiterableArray<T>;
    /**
     * Create a new {@link AsyncReiterableArray} with the given data elements
     * that will not be ended.
     * @param {T[]} initialData An array of initial data elements.
     * @return {AsyncReiterableArray<T>} A new open-ended {@link AsyncReiterableArray} with the given data elements.
     */
    static fromInitialData<T>(initialData: T[]): AsyncReiterableArray<T>;
    /**
     * @return {AsyncReiterableArray<T>} A new open-ended {@link AsyncReiterableArray} without data elements.
     */
    static fromInitialEmpty<T>(): AsyncReiterableArray<T>;
    protected static pushToIterator<T>(iterator: BufferedIterator<T>, data: T): void;
    iterator(): AsyncIterator<T>;
    push(data: T): void;
    isEnded(): boolean;
}
