import * as tslib_1 from "tslib";
import { utils } from '@atlaskit/util-service-support';
export default class ActivityResource {
    constructor(baseUrl, cloudId) {
        this.serviceConfig = { url: baseUrl };
        this.cloudId = cloudId;
    }
    getFrequentItems() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.frequentPromise) {
                const options = {
                    path: 'api/frequent',
                    queryParams: {
                        'cloudId': this.cloudId
                    },
                    requestInit: {
                        mode: 'cors'
                    }
                };
                this.frequentPromise = utils.requestService(this.serviceConfig, options);
            }
            const response = yield this.frequentPromise;
            return response.data;
        });
    }
    getRecentItems() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.recentPromise) {
                const options = {
                    path: 'api/client/recent',
                    queryParams: {
                        'cloudId': this.cloudId
                    },
                    requestInit: {
                        mode: 'cors'
                    }
                };
                this.recentPromise = utils.requestService(this.serviceConfig, options);
            }
            const response = yield this.recentPromise;
            return response.data;
        });
    }
    searchRecent(search) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const items = yield this.getRecentItems();
            return this.filterItems(items, search);
        });
    }
    filterItems(items, searchTerm) {
        if (searchTerm.length === 0) {
            return [];
        }
        searchTerm = searchTerm.toLowerCase();
        return items.filter((item) => {
            return item.name.toLowerCase().indexOf(searchTerm) > -1;
        });
    }
}
//# sourceMappingURL=ActivityResource.js.map