import * as tslib_1 from "tslib";
import ActivityResource from '../api/ActivityResource';
import * as frequentData from './mock-frequent-data.json';
import * as recentData from './mock-recent-data.json';
function timeout(ms = 1) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
export default class MockActivityResource extends ActivityResource {
    constructor() {
        super('', '');
    }
    getFrequentItems() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield timeout(500); // simulate rest delay
            return Promise.resolve(frequentData.data);
        });
    }
    getRecentItems() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return Promise.resolve(recentData.data);
        });
    }
}
//# sourceMappingURL=MockActivityResource.js.map