"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var util_service_support_1 = require("@atlaskit/util-service-support");
var ActivityResource = (function () {
    function ActivityResource(baseUrl, cloudId) {
        this.serviceConfig = { url: baseUrl };
        this.cloudId = cloudId;
    }
    ActivityResource.prototype.getFrequentItems = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var options, response;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.frequentPromise) {
                            options = {
                                path: 'api/frequent',
                                queryParams: {
                                    'cloudId': this.cloudId
                                },
                                requestInit: {
                                    mode: 'cors'
                                }
                            };
                            this.frequentPromise = util_service_support_1.utils.requestService(this.serviceConfig, options);
                        }
                        return [4 /*yield*/, this.frequentPromise];
                    case 1:
                        response = _a.sent();
                        return [2 /*return*/, response.data];
                }
            });
        });
    };
    ActivityResource.prototype.getRecentItems = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var options, response;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.recentPromise) {
                            options = {
                                path: 'api/client/recent',
                                queryParams: {
                                    'cloudId': this.cloudId
                                },
                                requestInit: {
                                    mode: 'cors'
                                }
                            };
                            this.recentPromise = util_service_support_1.utils.requestService(this.serviceConfig, options);
                        }
                        return [4 /*yield*/, this.recentPromise];
                    case 1:
                        response = _a.sent();
                        return [2 /*return*/, response.data];
                }
            });
        });
    };
    ActivityResource.prototype.searchRecent = function (search) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var items;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getRecentItems()];
                    case 1:
                        items = _a.sent();
                        return [2 /*return*/, this.filterItems(items, search)];
                }
            });
        });
    };
    ActivityResource.prototype.filterItems = function (items, searchTerm) {
        if (searchTerm.length === 0) {
            return [];
        }
        searchTerm = searchTerm.toLowerCase();
        return items.filter(function (item) {
            return item.name.toLowerCase().indexOf(searchTerm) > -1;
        });
    };
    return ActivityResource;
}());
exports.default = ActivityResource;
//# sourceMappingURL=ActivityResource.js.map