"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var ActivityResource_1 = require("../api/ActivityResource");
var frequentData = require("./mock-frequent-data.json");
var recentData = require("./mock-recent-data.json");
function timeout(ms) {
    if (ms === void 0) { ms = 1; }
    return new Promise(function (resolve) { return setTimeout(resolve, ms); });
}
var MockActivityResource = (function (_super) {
    tslib_1.__extends(MockActivityResource, _super);
    function MockActivityResource() {
        return _super.call(this, '', '') || this;
    }
    MockActivityResource.prototype.getFrequentItems = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, timeout(500)];
                    case 1:
                        _a.sent(); // simulate rest delay
                        return [2 /*return*/, Promise.resolve(frequentData.data)];
                }
            });
        });
    };
    MockActivityResource.prototype.getRecentItems = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, Promise.resolve(recentData.data)];
            });
        });
    };
    return MockActivityResource;
}(ActivityResource_1.default));
exports.default = MockActivityResource;
//# sourceMappingURL=MockActivityResource.js.map