import React from 'react';
import { fg } from '@atlaskit/platform-feature-flags';
import isModernContextEnabledEnv from '../../utils/isModernContextEnabledEnv';
import LegacyAnalyticsContext from './LegacyAnalyticsContext';
import ModernAnalyticsContext from './ModernAnalyticsContext';
const ExportedAnalyticsContext = props => {
  const isModernContext = isModernContextEnabledEnv || fg('platform.analytics-next-use-modern-context_fqgbx');
  return isModernContext ? /*#__PURE__*/React.createElement(ModernAnalyticsContext, props) : /*#__PURE__*/React.createElement(LegacyAnalyticsContext, props);
};
export default ExportedAnalyticsContext;