import React, { Component } from 'react';
import { fg } from '@atlaskit/platform-feature-flags';
import isModernContextEnabledEnv from '../utils/isModernContextEnabledEnv';
import LegacyAnalyticsContext from './AnalyticsContext/LegacyAnalyticsContext';
import ModernAnalyticsContext from './AnalyticsContext/ModernAnalyticsContext';
/**
 *  @private https://product-fabric.atlassian.net/browse/AFO-815
 *  @deprecated
 */
// eslint-disable-next-line @repo/internal/react/no-class-components
export default class AnalyticsErrorBoundary extends Component {
  constructor(props) {
    super(props);
    this.state = {
      hasError: false
    };
  }
  componentDidCatch(error, info) {
    const {
      onError
    } = this.props;
    onError && onError(error, info);
    this.setState({
      hasError: true
    });
  }
  render() {
    const {
      data,
      children,
      ErrorComponent
    } = this.props;
    const {
      hasError
    } = this.state;
    const isModernContext = isModernContextEnabledEnv || fg('platform.analytics-next-use-modern-context_fqgbx');
    if (hasError) {
      if (ErrorComponent) {
        if (isModernContext) {
          return /*#__PURE__*/React.createElement(ModernAnalyticsContext, {
            data: data
          }, /*#__PURE__*/React.createElement(ErrorComponent, null));
        }
        return /*#__PURE__*/React.createElement(LegacyAnalyticsContext, {
          data: data
        }, /*#__PURE__*/React.createElement(ErrorComponent, null));
      }
      return null;
    }
    if (isModernContext) {
      return /*#__PURE__*/React.createElement(ModernAnalyticsContext, {
        data: data
      }, children);
    }
    return /*#__PURE__*/React.createElement(LegacyAnalyticsContext, {
      data: data
    }, children);
  }
}