import _defineProperty from "@babel/runtime/helpers/defineProperty";
import AnalyticsEvent from './AnalyticsEvent';
export const isUIAnalyticsEvent = obj => {
  var _obj$constructor;
  return obj instanceof UIAnalyticsEvent || !!(obj !== null && obj !== void 0 && obj._isUIAnalyticsEvent) ||
  // Backwards compatibility with older analytics-next packages
  (obj === null || obj === void 0 ? void 0 : (_obj$constructor = obj.constructor) === null || _obj$constructor === void 0 ? void 0 : _obj$constructor.name) === 'UIAnalyticsEvent';
};
export default class UIAnalyticsEvent extends AnalyticsEvent {
  constructor(props) {
    super(props);
    _defineProperty(this, "_isUIAnalyticsEvent", true);
    _defineProperty(this, "clone", () => {
      if (this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot clone an event after it's been fired.");
        }
        return null;
      }
      const context = [...this.context];
      const handlers = [...this.handlers];

      /**
       * A hacky "deep clone" of the object. This is limited in that it wont
       * support functions, regexs, Maps, Sets, etc, but none of those need to
       * be represented in our payload.
       */
      const payload = JSON.parse(JSON.stringify(this.payload));
      return new UIAnalyticsEvent({
        context,
        handlers,
        payload
      });
    });
    _defineProperty(this, "fire", channel => {
      if (this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn('Cannot fire an event twice.');
        }
        return;
      }
      this.handlers.forEach(handler => handler(this, channel));
      this.hasFired = true;
    });
    this.context = props.context || [];
    this.handlers = props.handlers || [];
    this.hasFired = false;
  }
  update(updater) {
    if (this.hasFired) {
      if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
        // eslint-disable-next-line no-console
        console.warn("Cannot update an event after it's been fired.");
      }
      return this;
    }
    return super.update(updater);
  }
}