import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _get from "@babel/runtime/helpers/get";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import AnalyticsEvent from './AnalyticsEvent';
export var isUIAnalyticsEvent = function isUIAnalyticsEvent(obj) {
  var _obj$constructor;
  return obj instanceof UIAnalyticsEvent || !!(obj !== null && obj !== void 0 && obj._isUIAnalyticsEvent) ||
  // Backwards compatibility with older analytics-next packages
  (obj === null || obj === void 0 || (_obj$constructor = obj.constructor) === null || _obj$constructor === void 0 ? void 0 : _obj$constructor.name) === 'UIAnalyticsEvent';
};
var UIAnalyticsEvent = /*#__PURE__*/function (_AnalyticsEvent) {
  _inherits(UIAnalyticsEvent, _AnalyticsEvent);
  var _super = _createSuper(UIAnalyticsEvent);
  function UIAnalyticsEvent(props) {
    var _this;
    _classCallCheck(this, UIAnalyticsEvent);
    _this = _super.call(this, props);
    _defineProperty(_assertThisInitialized(_this), "_isUIAnalyticsEvent", true);
    _defineProperty(_assertThisInitialized(_this), "clone", function () {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot clone an event after it's been fired.");
        }
        return null;
      }
      var context = _toConsumableArray(_this.context);
      var handlers = _toConsumableArray(_this.handlers);

      /**
       * A hacky "deep clone" of the object. This is limited in that it wont
       * support functions, regexs, Maps, Sets, etc, but none of those need to
       * be represented in our payload.
       */
      var payload = JSON.parse(JSON.stringify(_this.payload));
      return new UIAnalyticsEvent({
        context: context,
        handlers: handlers,
        payload: payload
      });
    });
    _defineProperty(_assertThisInitialized(_this), "fire", function (channel) {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn('Cannot fire an event twice.');
        }
        return;
      }
      _this.handlers.forEach(function (handler) {
        return handler(_assertThisInitialized(_this), channel);
      });
      _this.hasFired = true;
    });
    _this.context = props.context || [];
    _this.handlers = props.handlers || [];
    _this.hasFired = false;
    return _this;
  }
  _createClass(UIAnalyticsEvent, [{
    key: "update",
    value: function update(updater) {
      if (this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot update an event after it's been fired.");
        }
        return this;
      }
      return _get(_getPrototypeOf(UIAnalyticsEvent.prototype), "update", this).call(this, updater);
    }
  }]);
  return UIAnalyticsEvent;
}(AnalyticsEvent);
export { UIAnalyticsEvent as default };