import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { type AnalyticsReactContextInterface } from '@atlaskit/analytics-next-stable-react-context';
import type { default as UIAnalyticsEvent } from '../../events/UIAnalyticsEvent';
type Props = {
    /** Children! */
    children?: React.ReactNode;
    /** The channel to listen for events on. */
    channel?: string;
    /** A function which will be called when an event is fired on this Listener's
     * channel. It is passed the event and the channel as arguments. */
    onEvent: (event: UIAnalyticsEvent, channel?: string) => void;
};
declare class AnalyticsListener extends Component<Props> {
    context: any;
    static contextTypes: {
        getAtlaskitAnalyticsEventHandlers: PropTypes.Requireable<(...args: any[]) => any>;
        getAtlaskitAnalyticsContext: PropTypes.Requireable<(...args: any[]) => any>;
    };
    static childContextTypes: {
        getAtlaskitAnalyticsEventHandlers: PropTypes.Requireable<(...args: any[]) => any>;
        getAtlaskitAnalyticsContext: PropTypes.Requireable<(...args: any[]) => any>;
    };
    contextValue: AnalyticsReactContextInterface;
    constructor(props: Props);
    getChildContext: () => {
        getAtlaskitAnalyticsEventHandlers: () => any[];
        getAtlaskitAnalyticsContext: () => any;
    };
    getAnalyticsEventHandlers: () => any[];
    getAtlaskitAnalyticsContext: () => any;
    render(): JSX.Element;
}
export default AnalyticsListener;
