"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppProvider = AppProvider;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _routerLinkProvider = _interopRequireDefault(require("./router-link-provider"));
var _themeProvider = _interopRequireDefault(require("./theme-provider"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var InsideAppProviderContext = /*#__PURE__*/(0, _react.createContext)(false);
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
function AppProvider(_ref) {
  var children = _ref.children,
    _ref$defaultColorMode = _ref.defaultColorMode,
    defaultColorMode = _ref$defaultColorMode === void 0 ? 'light' : _ref$defaultColorMode,
    defaultTheme = _ref.defaultTheme,
    routerLinkComponent = _ref.routerLinkComponent;
  var isInsideAppProvider = (0, _react.useContext)(InsideAppProviderContext);
  if (isInsideAppProvider) {
    throw new Error('App provider should not be nested within another app provider.');
  }
  return /*#__PURE__*/_react.default.createElement(InsideAppProviderContext.Provider, {
    value: true
  }, /*#__PURE__*/_react.default.createElement(_themeProvider.default, {
    defaultColorMode: defaultColorMode,
    defaultTheme: defaultTheme
  }, /*#__PURE__*/_react.default.createElement(_routerLinkProvider.default, {
    routerLinkComponent: routerLinkComponent
  }, children)));
}
var _default = exports.default = AppProvider;