"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeProvider = ThemeProvider;
exports.default = void 0;
exports.useColorMode = useColorMode;
exports.useSetColorMode = useSetColorMode;
exports.useSetTheme = useSetTheme;
exports.useTheme = useTheme;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _bindEventListener = require("bind-event-listener");
var _tokens = require("@atlaskit/tokens");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var defaultThemeSettings = {
  dark: 'dark',
  light: 'light',
  spacing: 'spacing'
};
var ColorModeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var SetColorModeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var ThemeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
var SetThemeContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
function useColorMode() {
  var value = (0, _react.useContext)(ColorModeContext);
  if (!value) {
    throw new Error('useColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
function useSetColorMode() {
  var value = (0, _react.useContext)(SetColorModeContext);
  if (!value) {
    throw new Error('useSetColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
function useTheme() {
  var value = (0, _react.useContext)(ThemeContext);
  if (!value) {
    throw new Error('useTheme must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
function useSetTheme() {
  var value = (0, _react.useContext)(SetThemeContext);
  if (!value) {
    throw new Error('useSetTheme must be used within AppProvider.');
  }
  return value;
}
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;
var prefersDarkModeMql = isMatchMediaAvailable ? window.matchMedia('(prefers-color-scheme: dark)') : undefined;

// TODO: currently 'auto' color mode will always return 'light' in SSR.
// Additional work required: https://product-fabric.atlassian.net/browse/DSP-9781
function getReconciledColorMode(colorMode) {
  if (colorMode === 'auto') {
    return prefersDarkModeMql !== null && prefersDarkModeMql !== void 0 && prefersDarkModeMql.matches ? 'dark' : 'light';
  }
  return colorMode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
function ThemeProvider(_ref) {
  var children = _ref.children,
    defaultColorMode = _ref.defaultColorMode,
    _ref$defaultTheme = _ref.defaultTheme,
    _ref$defaultTheme2 = _ref$defaultTheme === void 0 ? defaultThemeSettings : _ref$defaultTheme,
    _ref$defaultTheme2$da = _ref$defaultTheme2.dark,
    dark = _ref$defaultTheme2$da === void 0 ? 'dark' : _ref$defaultTheme2$da,
    _ref$defaultTheme2$li = _ref$defaultTheme2.light,
    light = _ref$defaultTheme2$li === void 0 ? 'light' : _ref$defaultTheme2$li,
    _ref$defaultTheme2$sp = _ref$defaultTheme2.spacing,
    spacing = _ref$defaultTheme2$sp === void 0 ? 'spacing' : _ref$defaultTheme2$sp,
    typography = _ref$defaultTheme2.typography,
    shape = _ref$defaultTheme2.shape;
  var _useState = (0, _react.useState)(defaultColorMode),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    chosenColorMode = _useState2[0],
    setChosenColorMode = _useState2[1];
  var _useState3 = (0, _react.useState)(getReconciledColorMode(defaultColorMode)),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    reconciledColorMode = _useState4[0],
    setReconciledColorMode = _useState4[1];
  var _useState5 = (0, _react.useState)({
      dark: dark,
      light: light,
      spacing: spacing,
      typography: typography,
      shape: shape
    }),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    theme = _useState6[0],
    setTheme = _useState6[1];
  var setColorMode = (0, _react.useCallback)(function (colorMode) {
    setChosenColorMode(colorMode);
    setReconciledColorMode(getReconciledColorMode(colorMode));
  }, []);
  var setPartialTheme = (0, _react.useCallback)(function (nextTheme) {
    setTheme(function (theme) {
      return _objectSpread(_objectSpread({}, theme), nextTheme);
    });
  }, []);
  (0, _react.useEffect)(function () {
    (0, _tokens.setGlobalTheme)(_objectSpread(_objectSpread({}, theme), {}, {
      colorMode: reconciledColorMode
    }));
  }, [theme, reconciledColorMode]);
  (0, _react.useEffect)(function () {
    if (!prefersDarkModeMql) {
      return;
    }
    var unbindListener = (0, _bindEventListener.bind)(prefersDarkModeMql, {
      type: 'change',
      listener: function listener(event) {
        if (chosenColorMode === 'auto') {
          setReconciledColorMode(event.matches ? 'dark' : 'light');
        }
      }
    });
    return unbindListener;
  }, [chosenColorMode]);
  return /*#__PURE__*/_react.default.createElement(ColorModeContext.Provider, {
    value: reconciledColorMode
  }, /*#__PURE__*/_react.default.createElement(SetColorModeContext.Provider, {
    value: setColorMode
  }, /*#__PURE__*/_react.default.createElement(ThemeContext.Provider, {
    value: theme
  }, /*#__PURE__*/_react.default.createElement(SetThemeContext.Provider, {
    value: setPartialTheme
  }, children))));
}
var _default = exports.default = ThemeProvider;