import React, { createContext, useContext } from 'react';
import RouterLinkProvider from './router-link-provider';
import ThemeProvider from './theme-provider';
const InsideAppProviderContext = /*#__PURE__*/createContext(false);
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
export function AppProvider({
  children,
  defaultColorMode = 'light',
  defaultTheme,
  routerLinkComponent
}) {
  const isInsideAppProvider = useContext(InsideAppProviderContext);
  if (isInsideAppProvider) {
    throw new Error('App provider should not be nested within another app provider.');
  }
  return /*#__PURE__*/React.createElement(InsideAppProviderContext.Provider, {
    value: true
  }, /*#__PURE__*/React.createElement(ThemeProvider, {
    defaultColorMode: defaultColorMode,
    defaultTheme: defaultTheme
  }, /*#__PURE__*/React.createElement(RouterLinkProvider, {
    routerLinkComponent: routerLinkComponent
  }, children)));
}
export default AppProvider;