import React, { createContext } from 'react';
export const RouterLinkProviderContext = /*#__PURE__*/createContext({});
/**
 * __RouterLinkProvider__
 *
 * Provides a configured router link component for use
 * within Design System components.
 */
const RouterLinkProvider = ({
  routerLinkComponent,
  children
}) => {
  return /*#__PURE__*/React.createElement(RouterLinkProviderContext.Provider, {
    value: {
      routerLinkComponent
    }
  }, children);
};
export default RouterLinkProvider;