import React, { createContext, useContext } from 'react';
import RouterLinkProvider from './router-link-provider';
import ThemeProvider from './theme-provider';
var InsideAppProviderContext = /*#__PURE__*/createContext(false);
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
export function AppProvider(_ref) {
  var children = _ref.children,
    _ref$defaultColorMode = _ref.defaultColorMode,
    defaultColorMode = _ref$defaultColorMode === void 0 ? 'light' : _ref$defaultColorMode,
    defaultTheme = _ref.defaultTheme,
    routerLinkComponent = _ref.routerLinkComponent;
  var isInsideAppProvider = useContext(InsideAppProviderContext);
  if (isInsideAppProvider) {
    throw new Error('App provider should not be nested within another app provider.');
  }
  return /*#__PURE__*/React.createElement(InsideAppProviderContext.Provider, {
    value: true
  }, /*#__PURE__*/React.createElement(ThemeProvider, {
    defaultColorMode: defaultColorMode,
    defaultTheme: defaultTheme
  }, /*#__PURE__*/React.createElement(RouterLinkProvider, {
    routerLinkComponent: routerLinkComponent
  }, children)));
}
export default AppProvider;