import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import React, { createContext, useCallback, useContext, useEffect, useState } from 'react';
import { bind } from 'bind-event-listener';
import { setGlobalTheme } from '@atlaskit/tokens';
var defaultThemeSettings = {
  dark: 'dark',
  light: 'light',
  spacing: 'spacing'
};
var ColorModeContext = /*#__PURE__*/createContext(undefined);
var SetColorModeContext = /*#__PURE__*/createContext(undefined);
var ThemeContext = /*#__PURE__*/createContext(undefined);
var SetThemeContext = /*#__PURE__*/createContext(undefined);

/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
export function useColorMode() {
  var value = useContext(ColorModeContext);
  if (!value) {
    throw new Error('useColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
export function useSetColorMode() {
  var value = useContext(SetColorModeContext);
  if (!value) {
    throw new Error('useSetColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
export function useTheme() {
  var value = useContext(ThemeContext);
  if (!value) {
    throw new Error('useTheme must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
export function useSetTheme() {
  var value = useContext(SetThemeContext);
  if (!value) {
    throw new Error('useSetTheme must be used within AppProvider.');
  }
  return value;
}
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;
var prefersDarkModeMql = isMatchMediaAvailable ? window.matchMedia('(prefers-color-scheme: dark)') : undefined;

// TODO: currently 'auto' color mode will always return 'light' in SSR.
// Additional work required: https://product-fabric.atlassian.net/browse/DSP-9781
function getReconciledColorMode(colorMode) {
  if (colorMode === 'auto') {
    return prefersDarkModeMql !== null && prefersDarkModeMql !== void 0 && prefersDarkModeMql.matches ? 'dark' : 'light';
  }
  return colorMode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
export function ThemeProvider(_ref) {
  var children = _ref.children,
    defaultColorMode = _ref.defaultColorMode,
    _ref$defaultTheme = _ref.defaultTheme,
    _ref$defaultTheme2 = _ref$defaultTheme === void 0 ? defaultThemeSettings : _ref$defaultTheme,
    _ref$defaultTheme2$da = _ref$defaultTheme2.dark,
    dark = _ref$defaultTheme2$da === void 0 ? 'dark' : _ref$defaultTheme2$da,
    _ref$defaultTheme2$li = _ref$defaultTheme2.light,
    light = _ref$defaultTheme2$li === void 0 ? 'light' : _ref$defaultTheme2$li,
    _ref$defaultTheme2$sp = _ref$defaultTheme2.spacing,
    spacing = _ref$defaultTheme2$sp === void 0 ? 'spacing' : _ref$defaultTheme2$sp,
    typography = _ref$defaultTheme2.typography,
    shape = _ref$defaultTheme2.shape;
  var _useState = useState(defaultColorMode),
    _useState2 = _slicedToArray(_useState, 2),
    chosenColorMode = _useState2[0],
    setChosenColorMode = _useState2[1];
  var _useState3 = useState(getReconciledColorMode(defaultColorMode)),
    _useState4 = _slicedToArray(_useState3, 2),
    reconciledColorMode = _useState4[0],
    setReconciledColorMode = _useState4[1];
  var _useState5 = useState({
      dark: dark,
      light: light,
      spacing: spacing,
      typography: typography,
      shape: shape
    }),
    _useState6 = _slicedToArray(_useState5, 2),
    theme = _useState6[0],
    setTheme = _useState6[1];
  var setColorMode = useCallback(function (colorMode) {
    setChosenColorMode(colorMode);
    setReconciledColorMode(getReconciledColorMode(colorMode));
  }, []);
  var setPartialTheme = useCallback(function (nextTheme) {
    setTheme(function (theme) {
      return _objectSpread(_objectSpread({}, theme), nextTheme);
    });
  }, []);
  useEffect(function () {
    setGlobalTheme(_objectSpread(_objectSpread({}, theme), {}, {
      colorMode: reconciledColorMode
    }));
  }, [theme, reconciledColorMode]);
  useEffect(function () {
    if (!prefersDarkModeMql) {
      return;
    }
    var unbindListener = bind(prefersDarkModeMql, {
      type: 'change',
      listener: function listener(event) {
        if (chosenColorMode === 'auto') {
          setReconciledColorMode(event.matches ? 'dark' : 'light');
        }
      }
    });
    return unbindListener;
  }, [chosenColorMode]);
  return /*#__PURE__*/React.createElement(ColorModeContext.Provider, {
    value: reconciledColorMode
  }, /*#__PURE__*/React.createElement(SetColorModeContext.Provider, {
    value: setColorMode
  }, /*#__PURE__*/React.createElement(ThemeContext.Provider, {
    value: theme
  }, /*#__PURE__*/React.createElement(SetThemeContext.Provider, {
    value: setPartialTheme
  }, children))));
}
export default ThemeProvider;