import React from 'react';
import { type RouterLinkComponent } from './router-link-provider';
import { type ColorMode, type Theme } from './theme-provider';
interface AppProviderProps {
    /**
     * Initial color mode.
     */
    defaultColorMode?: ColorMode;
    /**
     * Theme settings.
     */
    defaultTheme?: Partial<Theme>;
    /**
     * A configured router link component.
     */
    routerLinkComponent?: RouterLinkComponent<any>;
    /**
     * App content.
     */
    children: React.ReactNode;
}
/**
 * __App provider__
 *
 * An app provider provides app level configuration such as global theming.
 *
 * Place it at the root of your application.
 */
export declare function AppProvider({ children, defaultColorMode, defaultTheme, routerLinkComponent, }: AppProviderProps): JSX.Element;
export default AppProvider;
