import React from 'react';
import { type ThemeState } from '@atlaskit/tokens';
export type Theme = Omit<ThemeState, 'colorMode' | 'contrastMode'>;
export type ColorMode = 'light' | 'dark' | 'auto';
export type ReconciledColorMode = Exclude<ColorMode, 'auto'>;
/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
export declare function useColorMode(): ReconciledColorMode;
/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
export declare function useSetColorMode(): (value: ColorMode) => void;
/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
export declare function useTheme(): Theme;
/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
export declare function useSetTheme(): (value: Partial<Theme>) => void;
interface ThemeProviderProps {
    defaultColorMode: ColorMode;
    defaultTheme?: Partial<Theme>;
    children: React.ReactNode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
export declare function ThemeProvider({ children, defaultColorMode, defaultTheme: { dark, light, spacing, typography, shape, }, }: ThemeProviderProps): JSX.Element;
export default ThemeProvider;
