"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _usePlatformLeafEventHandler = require("@atlaskit/analytics-next/usePlatformLeafEventHandler");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _colors = require("@atlaskit/theme/colors");
var _components = require("@atlaskit/theme/components");
var _constants = require("@atlaskit/theme/constants");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var packageName = "@atlaskit/blanket";
var packageVersion = "12.4.4";
var analyticsAttributes = {
  componentName: 'blanket',
  packageName: packageName,
  packageVersion: packageVersion
};
var baseStyles = (0, _react2.css)({
  position: 'fixed',
  zIndex: _constants.layers.blanket(),
  inset: 0,
  overflowY: 'auto',
  pointerEvents: 'initial'
});
var shouldAllowClickThroughStyles = (0, _react2.css)({
  pointerEvents: 'none'
});
var invisibleStyles = (0, _react2.css)({
  backgroundColor: 'transparent'
});
var lightBgStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-blanket, ".concat(_colors.N100A, ")")
});
var darkBgStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-blanket, ".concat(_colors.DN90A, ")")
});
var backgroundStyle = {
  light: lightBgStyles,
  dark: darkBgStyles
};

/**
 * __Blanket__
 *
 * A Blanket provides the overlay layer for components such as a modal dialog or a tooltip
 *
 * - [Examples](https://atlaskit.atlassian.com/examples/design-system/blanket/basic-usage)
 */
var Blanket = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function Blanket(_ref, ref) {
  var _ref$shouldAllowClick = _ref.shouldAllowClickThrough,
    shouldAllowClickThrough = _ref$shouldAllowClick === void 0 ? false : _ref$shouldAllowClick,
    _ref$isTinted = _ref.isTinted,
    isTinted = _ref$isTinted === void 0 ? false : _ref$isTinted,
    _ref$onBlanketClicked = _ref.onBlanketClicked,
    onBlanketClicked = _ref$onBlanketClicked === void 0 ? _noop.default : _ref$onBlanketClicked,
    testId = _ref.testId,
    children = _ref.children,
    analyticsContext = _ref.analyticsContext;
  var _useGlobalTheme = (0, _components.useGlobalTheme)(),
    mode = _useGlobalTheme.mode;
  var mouseDownTarget = (0, _react.useRef)(null);
  var onBlanketClickedWithAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)(_objectSpread({
    fn: onBlanketClicked,
    action: 'clicked',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var blanketClickOutsideChildren = (0, _react.useCallback)(function (e) {
    return e.currentTarget === e.target && mouseDownTarget.current === e.target ? onBlanketClickedWithAnalytics(e) : undefined;
  }, [onBlanketClickedWithAnalytics]);
  var onClick = shouldAllowClickThrough ? undefined : blanketClickOutsideChildren;
  var onMouseDown = (0, _react.useCallback)(function (e) {
    mouseDownTarget.current = e.target;
  }, []);
  return (
    // TODO: Remove role="presentation", since div's have no semantics anyway (DSP-11587)
    (0, _react2.jsx)("div", {
      role: "presentation",
      css: [baseStyles, shouldAllowClickThrough && shouldAllowClickThroughStyles, backgroundStyle[mode], !isTinted && invisibleStyles],
      onClick: onClick,
      onMouseDown: onMouseDown,
      "data-testid": testId,
      ref: ref
    }, children)
  );
}));
Blanket.displayName = 'Blanket';
var _default = Blanket;
exports.default = _default;