import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { forwardRef, memo, useCallback, useRef } from 'react';
import { css, jsx } from '@emotion/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next/usePlatformLeafEventHandler';
import noop from '@atlaskit/ds-lib/noop';
import { DN90A, N100A } from '@atlaskit/theme/colors';
import { useGlobalTheme } from '@atlaskit/theme/components';
import { layers } from '@atlaskit/theme/constants';
var packageName = "@atlaskit/blanket";
var packageVersion = "12.4.4";
var analyticsAttributes = {
  componentName: 'blanket',
  packageName: packageName,
  packageVersion: packageVersion
};
var baseStyles = css({
  position: 'fixed',
  zIndex: layers.blanket(),
  inset: 0,
  overflowY: 'auto',
  pointerEvents: 'initial'
});
var shouldAllowClickThroughStyles = css({
  pointerEvents: 'none'
});
var invisibleStyles = css({
  backgroundColor: 'transparent'
});
var lightBgStyles = css({
  backgroundColor: "var(--ds-blanket, ".concat(N100A, ")")
});
var darkBgStyles = css({
  backgroundColor: "var(--ds-blanket, ".concat(DN90A, ")")
});
var backgroundStyle = {
  light: lightBgStyles,
  dark: darkBgStyles
};

/**
 * __Blanket__
 *
 * A Blanket provides the overlay layer for components such as a modal dialog or a tooltip
 *
 * - [Examples](https://atlaskit.atlassian.com/examples/design-system/blanket/basic-usage)
 */
var Blanket = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function Blanket(_ref, ref) {
  var _ref$shouldAllowClick = _ref.shouldAllowClickThrough,
    shouldAllowClickThrough = _ref$shouldAllowClick === void 0 ? false : _ref$shouldAllowClick,
    _ref$isTinted = _ref.isTinted,
    isTinted = _ref$isTinted === void 0 ? false : _ref$isTinted,
    _ref$onBlanketClicked = _ref.onBlanketClicked,
    onBlanketClicked = _ref$onBlanketClicked === void 0 ? noop : _ref$onBlanketClicked,
    testId = _ref.testId,
    children = _ref.children,
    analyticsContext = _ref.analyticsContext;
  var _useGlobalTheme = useGlobalTheme(),
    mode = _useGlobalTheme.mode;
  var mouseDownTarget = useRef(null);
  var onBlanketClickedWithAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: onBlanketClicked,
    action: 'clicked',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var blanketClickOutsideChildren = useCallback(function (e) {
    return e.currentTarget === e.target && mouseDownTarget.current === e.target ? onBlanketClickedWithAnalytics(e) : undefined;
  }, [onBlanketClickedWithAnalytics]);
  var onClick = shouldAllowClickThrough ? undefined : blanketClickOutsideChildren;
  var onMouseDown = useCallback(function (e) {
    mouseDownTarget.current = e.target;
  }, []);
  return (
    // TODO: Remove role="presentation", since div's have no semantics anyway (DSP-11587)
    jsx("div", {
      role: "presentation",
      css: [baseStyles, shouldAllowClickThrough && shouldAllowClickThroughStyles, backgroundStyle[mode], !isTinted && invisibleStyles],
      onClick: onClick,
      onMouseDown: onMouseDown,
      "data-testid": testId,
      ref: ref
    }, children)
  );
}));
Blanket.displayName = 'Blanket';
export default Blanket;