"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BidiWarning;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _tooltip = _interopRequireDefault(require("@atlaskit/tooltip"));
var _styled = require("./styled");
var _excluded = ["children"];
/**
 * __Bidi Warning__
 *
 * A component used to render a bidi character warning.
 * A bidi character can be used to perform a "bidi override attack".
 *
 * See https://hello.atlassian.net/wiki/spaces/PRODSEC/pages/1347434677/PSHELP-2943+Investigate+Trojan+Source+Attack+Vulnerability#1)-Providing-visual-cues-for-our-Customers-in-our-affected-products
 */
function BidiWarning(_ref) {
  var testId = _ref.testId,
    bidiCharacter = _ref.bidiCharacter,
    skipChildren = _ref.skipChildren,
    tooltipEnabled = _ref.tooltipEnabled,
    _ref$label = _ref.label,
    label = _ref$label === void 0 ? 'Bidirectional characters change the order that text is rendered. This could be used to obscure malicious code.' : _ref$label;
  if (tooltipEnabled) {
    return (
      /*#__PURE__*/
      // Following patches, this should be updated to use the render props signature which will provide aria attributes.
      // Note: this should be tested, as initial testing did not see attributes work with current tooltip implementation.
      _react.default.createElement(_tooltip.default, {
        content: label,
        tag: CustomizedTagWithRef
      }, /*#__PURE__*/_react.default.createElement(_styled.Decorator, {
        testId: testId,
        bidiCharacter: bidiCharacter
      }, skipChildren ? null : bidiCharacter))
    );
  }
  return /*#__PURE__*/_react.default.createElement(_styled.Decorator, {
    testId: testId,
    bidiCharacter: bidiCharacter
  }, skipChildren ? null : bidiCharacter);
}
var CustomizedTagWithRef = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  var children = props.children,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({}, rest, {
    ref: ref
  }), children);
});