"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _components = require("@atlaskit/theme/components");
var _useHighlight = require("./internal/hooks/use-highlight");
var _styles = require("./internal/theme/styles");
var _getNormalizedLanguage = require("./internal/utils/get-normalized-language");
var _syntaxHighlighter = _interopRequireDefault(require("./syntax-highlighter"));
/** @jsx jsx */

/**
 * __Code block__
 *
 * A code block highlights an entire block of code and keeps the formatting.
 *
 * - [Examples](https://atlassian.design/components/code/code-block/examples)
 * - [Code](https://atlassian.design/components/code/code-block/code)
 * - [Usage](https://atlassian.design/components/code/code-block/usage)
 */
var CodeBlock = /*#__PURE__*/(0, _react.memo)(function CodeBlock(_ref) {
  var _ref$showLineNumbers = _ref.showLineNumbers,
    showLineNumbers = _ref$showLineNumbers === void 0 ? true : _ref$showLineNumbers,
    _ref$language = _ref.language,
    providedLanguage = _ref$language === void 0 ? 'text' : _ref$language,
    _ref$highlight = _ref.highlight,
    highlight = _ref$highlight === void 0 ? '' : _ref$highlight,
    _ref$highlightedStart = _ref.highlightedStartText,
    highlightedStartText = _ref$highlightedStart === void 0 ? 'Highlight start' : _ref$highlightedStart,
    _ref$highlightedEndTe = _ref.highlightedEndText,
    highlightedEndText = _ref$highlightedEndTe === void 0 ? 'Highlight end' : _ref$highlightedEndTe,
    testId = _ref.testId,
    text = _ref.text,
    _ref$codeBidiWarnings = _ref.codeBidiWarnings,
    codeBidiWarnings = _ref$codeBidiWarnings === void 0 ? true : _ref$codeBidiWarnings,
    codeBidiWarningLabel = _ref.codeBidiWarningLabel,
    _ref$codeBidiWarningT = _ref.codeBidiWarningTooltipEnabled,
    codeBidiWarningTooltipEnabled = _ref$codeBidiWarningT === void 0 ? true : _ref$codeBidiWarningT,
    _ref$shouldWrapLongLi = _ref.shouldWrapLongLines,
    shouldWrapLongLines = _ref$shouldWrapLongLi === void 0 ? false : _ref$shouldWrapLongLi;
  var numLines = (text || '').split('\n').length;
  var globalTheme = (0, _components.useGlobalTheme)();
  var theme = (0, _react.useMemo)(function () {
    return (0, _styles.getCodeBlockTheme)(globalTheme, numLines);
  }, [globalTheme, numLines]);
  var getStyles = (0, _react.useMemo)(function () {
    return (0, _styles.getCodeBlockStyles)(theme);
  }, [theme]);
  var styles = (0, _react.useMemo)(function () {
    return (0, _react2.css)(getStyles(highlightedStartText, highlightedEndText, showLineNumbers, shouldWrapLongLines));
  }, [highlightedStartText, highlightedEndText, showLineNumbers, shouldWrapLongLines, getStyles]);
  var _useHighlightLines = (0, _useHighlight.useHighlightLines)({
      highlight: highlight,
      testId: testId
    }),
    getHighlightStyles = _useHighlightLines.getHighlightStyles,
    highlightedLines = _useHighlightLines.highlightedLines;
  var getLineProps = (0, _react.useCallback)(function (line) {
    return getHighlightStyles(line, highlightedLines);
  }, [getHighlightStyles, highlightedLines]);
  var language = (0, _react.useMemo)(function () {
    return (0, _getNormalizedLanguage.normalizeLanguage)(providedLanguage);
  }, [providedLanguage]);

  // https://product-fabric.atlassian.net/browse/DST-2472
  var languageToUse = text ? language : 'text';
  return (0, _react2.jsx)(_syntaxHighlighter.default, {
    "data-code-lang": language,
    "data-ds--code--code-block": "",
    testId: testId,
    language: languageToUse,
    css: styles,
    showLineNumbers: showLineNumbers,
    lineProps: getLineProps
    // shouldCreateParentElementForLines is needed to pass down props to each line.
    // This is necessary for both line highlighting and testId's, as each of
    // these rely on a data attribute being passed down to lines.
    ,
    shouldCreateParentElementForLines: highlight.length > 0 || !!testId,
    shouldWrapLongLines: shouldWrapLongLines,
    codeBidiWarnings: codeBidiWarnings,
    codeBidiWarningLabel: codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled,
    text: text
  });
});
CodeBlock.displayName = 'CodeBlock';
var _default = CodeBlock;
exports.default = _default;