"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
Object.defineProperty(exports, "getCodeStyles", {
  enumerable: true,
  get: function get() {
    return _styles.getCodeStyles;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _components = require("@atlaskit/theme/components");
var _bidiWarning = _interopRequireDefault(require("./bidi-warning"));
var _bidiWarningDecorator = _interopRequireDefault(require("./bidi-warning/bidi-warning-decorator"));
var _styles = require("./internal/theme/styles");
var _excluded = ["testId"],
  _excluded2 = ["children", "codeBidiWarnings", "codeBidiWarningLabel", "codeBidiWarningTooltipEnabled"];
/** @jsx jsx */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * __Code__
 *
 * Code highlights short strings of code snippets inline with body text.
 *
 * - [Examples](https://atlassian.design/components/code/examples)
 * - [Code](https://atlassian.design/components/code/code)
 * - [Usage](https://atlassian.design/components/code/usage)
 */
var Code = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function Code(_ref, ref) {
  var testId = _ref.testId,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var theme = (0, _components.useGlobalTheme)();
  var styles = (0, _react.useMemo)(function () {
    return (0, _react2.css)((0, _styles.getCodeStyles)(theme));
  }, [theme]);
  var children = props.children,
    _props$codeBidiWarnin = props.codeBidiWarnings,
    codeBidiWarnings = _props$codeBidiWarnin === void 0 ? true : _props$codeBidiWarnin,
    codeBidiWarningLabel = props.codeBidiWarningLabel,
    _props$codeBidiWarnin2 = props.codeBidiWarningTooltipEnabled,
    codeBidiWarningTooltipEnabled = _props$codeBidiWarnin2 === void 0 ? true : _props$codeBidiWarnin2,
    otherProps = (0, _objectWithoutProperties2.default)(props, _excluded2);
  var decoratedChildren = codeBidiWarnings ? (0, _react2.jsx)(RenderCodeChildrenWithBidiWarnings, {
    codeBidiWarningLabel: codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
  }, children) : children;
  return (0, _react2.jsx)("code", (0, _extends2.default)({
    ref: ref,
    "data-testid": testId,
    css: styles
  }, otherProps), decoratedChildren);
}));
function RenderCodeChildrenWithBidiWarnings(_ref2) {
  var children = _ref2.children,
    codeBidiWarningLabel = _ref2.codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled = _ref2.codeBidiWarningTooltipEnabled;
  var replacedChildren = _react.default.Children.map(children, function (childNode) {
    if (typeof childNode === 'string') {
      var decorated = (0, _bidiWarningDecorator.default)(childNode, function (_ref3) {
        var bidiCharacter = _ref3.bidiCharacter,
          index = _ref3.index;
        return (0, _react2.jsx)(_bidiWarning.default, {
          bidiCharacter: bidiCharacter,
          key: index,
          label: codeBidiWarningLabel,
          tooltipEnabled: codeBidiWarningTooltipEnabled
        });
      });
      return decorated;
    }
    if (isReactElement(childNode) && childNode.props.children) {
      // eslint-disable-next-line @repo/internal/react/no-clone-element
      var newChildNode = /*#__PURE__*/_react.default.cloneElement(childNode, {
        children: (0, _react2.jsx)(RenderCodeChildrenWithBidiWarnings, {
          codeBidiWarningLabel: codeBidiWarningLabel,
          codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
        }, childNode.props.children)
      });
      return newChildNode;
    }
    return childNode;
  });
  return (0, _react2.jsx)(_react.default.Fragment, null, replacedChildren);
}
function isReactElement(child) {
  return !!child.type;
}
Code.displayName = 'Code';
var _default = Code;
exports.default = _default;