"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightLines = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var DEFAULT_LINE_EL_ATTR_OBJ = {
  'data-ds--code--row': ''
};
var getLineStyleObject = function getLineStyleObject(lineNumber, testId) {
  return testId ? _objectSpread({
    'data-testid': "".concat(testId, "-line-").concat(lineNumber)
  }, DEFAULT_LINE_EL_ATTR_OBJ) : DEFAULT_LINE_EL_ATTR_OBJ;
};
var useHighlightLines = function useHighlightLines(_ref) {
  var _ref$highlight = _ref.highlight,
    highlight = _ref$highlight === void 0 ? '' : _ref$highlight,
    testId = _ref.testId;
  var highlightedLines = (0, _react.useMemo)(function () {
    if (!highlight) {
      return [];
    }
    return highlight.split(',').map(function (num) {
      if (num.indexOf('-') > 0) {
        // We found a line group, e.g. 1-3
        var _num$split$map$sort = num.split('-').map(Number)
          // Sort by lowest value first, highest value last.
          .sort(function (a, b) {
            return a - b;
          }),
          _num$split$map$sort2 = (0, _slicedToArray2.default)(_num$split$map$sort, 2),
          from = _num$split$map$sort2[0],
          to = _num$split$map$sort2[1];
        return Array(to + 1).fill(undefined).map(function (_, index) {
          return index;
        }).slice(from, to + 1);
      }
      return Number(num);
    }).reduce(function (acc, val) {
      return acc.concat(val);
    }, []) || [];
  }, [highlight]);
  var getHighlightStyles = (0, _react.useCallback)(function (lineNumber, highlightedLines) {
    if (!highlight || highlightedLines.length === 0) {
      return getLineStyleObject(lineNumber, testId);
    }
    if (highlightedLines.includes(lineNumber)) {
      var highlightedDataAttrObj = {
        'data-ds--code--row--highlight': ''
      };
      return _objectSpread(_objectSpread({}, highlightedDataAttrObj), getLineStyleObject(lineNumber, testId));
    }
    return getLineStyleObject(lineNumber, testId);
  }, [highlight, testId]);
  return {
    getHighlightStyles: getHighlightStyles,
    highlightedLines: highlightedLines
  };
};
exports.useHighlightLines = useHighlightLines;