"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorPalette = exports.getBaseTheme = exports.defaultBaseTheme = exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var colors = _interopRequireWildcard(require("@atlaskit/theme/colors"));
var _components = require("@atlaskit/theme/components");
var _constants = require("@atlaskit/theme/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
// Hardcoded values have been used due to the current color palette not having any
// accessible color options for Teal and Yellow and +20A
var T800 = '#067384';
var Y1100 = '#7A5D1A';
var PLUS20 = '#3A434E';
var getBaseTheme = function getBaseTheme(theme) {
  return {
    fontFamily: (0, _constants.codeFontFamily)(),
    fontFamilyItalic: "SFMono-MediumItalic, ".concat((0, _constants.codeFontFamily)()),
    backgroundColor: (0, _components.themed)({
      light: "var(--ds-background-neutral, ".concat(colors.N20, ")"),
      dark: "var(--ds-background-neutral, ".concat(colors.DN50, ")")
    })({
      theme: theme
    }),
    textColor: (0, _components.themed)({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })({
      theme: theme
    }),
    lineNumberColor: (0, _components.themed)({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })({
      theme: theme
    }),
    lineNumberBgColor: (0, _components.themed)({
      light: "var(--ds-background-neutral, ".concat(colors.N30, ")"),
      dark: "var(--ds-background-neutral, ".concat(colors.DN20, ")")
    })({
      theme: theme
    })
  };
};
exports.getBaseTheme = getBaseTheme;
var defaultBaseTheme = getBaseTheme({
  mode: 'light'
});
exports.defaultBaseTheme = defaultBaseTheme;
var getColorPalette = (0, _memoizeOne.default)(function (theme) {
  var akTheme = {
    theme: theme
  };
  return {
    highlightedLineBgColor: (0, _components.themed)({
      light: "var(--ds-background-neutral, ".concat(colors.N30, ")"),
      dark: "var(--ds-background-neutral, ".concat(PLUS20, ")")
    })(akTheme),
    highlightedLineBorderColor: (0, _components.themed)({
      light: "var(--ds-border-focused, ".concat(colors.B200, ")"),
      dark: "var(--ds-border-focused, ".concat(colors.B100, ")")
    })(akTheme),
    substringColor: (0, _components.themed)({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    keywordColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    attributeColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    selectorTagColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    docTagColor: (0, _components.themed)({
      light: "var(--ds-text-accent-yellow, ".concat(Y1100, ")"),
      dark: "var(--ds-text-accent-yellow, ".concat(colors.Y300, ")")
    })(akTheme),
    nameColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    builtInColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    literalColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    bulletColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    codeColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    regexpColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    symbolColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    variableColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    templateVariableColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    linkColor: (0, _components.themed)({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    selectorAttributeColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    selectorPseudoColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    typeColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    stringColor: (0, _components.themed)({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    selectorIdColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    selectorClassColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    quoteColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    templateTagColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    titleColor: (0, _components.themed)({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    sectionColor: (0, _components.themed)({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    commentColor: (0, _components.themed)({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    metaKeywordColor: (0, _components.themed)({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    metaColor: (0, _components.themed)({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    functionColor: (0, _components.themed)({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    numberColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    prologColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    cdataColor: (0, _components.themed)({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.B75, ")")
    })(akTheme),
    punctuationColor: (0, _components.themed)({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    propertyColor: (0, _components.themed)({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    constantColor: (0, _components.themed)({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    booleanColor: (0, _components.themed)({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    charColor: (0, _components.themed)({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    insertedColor: (0, _components.themed)({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.B75, ")")
    })(akTheme),
    deletedColor: (0, _components.themed)({
      light: "var(--ds-text-accent-red, ".concat(colors.R500, ")"),
      dark: "var(--ds-text-accent-red, ".concat(colors.B75, ")")
    })(akTheme),
    operatorColor: (0, _components.themed)({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.B75, ")")
    })(akTheme),
    atruleColor: (0, _components.themed)({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    importantColor: (0, _components.themed)({
      light: "var(--ds-text-accent-yellow, ".concat(Y1100, ")"),
      dark: "var(--ds-text-accent-yellow, ".concat(colors.Y300, ")")
    })(akTheme)
  };
});
exports.getColorPalette = getColorPalette;
var getTheme = function getTheme(theme) {
  return _objectSpread(_objectSpread({}, getBaseTheme(theme)), getColorPalette(theme));
};
var _default = getTheme;
exports.default = _default;