"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeLanguage = void 0;
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _constants = require("../../constants");
var normalizeLanguage = (0, _memoizeOne.default)(function (language) {
  if (!language) {
    return '';
  }
  var match = _constants.SUPPORTED_LANGUAGES.find(function (val) {
    return val.name === language || val.alias.includes(language);
  });
  // Fallback to plain monospaced text if language passed but not supported
  return match ? match.value : 'text';
});
exports.normalizeLanguage = normalizeLanguage;