"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _process = _interopRequireDefault(require("./process"));
var _reactRenderer = _interopRequireDefault(require("./react-renderer"));
var _excluded = ["language", "testId", "text", "codeTagProps", "showLineNumbers", "shouldCreateParentElementForLines", "shouldWrapLongLines", "lineProps", "codeBidiWarnings", "codeBidiWarningLabel", "codeBidiWarningTooltipEnabled", "astGenerator"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/**
 * Takes in a code string and (in the default behaviour):
 * - Uses refractor to turn it into a tree structure with highlighting metadata
 * - Collapses this tree into lines for a renderer
 * - Passes these lines to a React renderer
 *
 * In future, the final step could have a custom renderer.
 */
var Highlight = /*#__PURE__*/(0, _react.memo)(function Highlight(_ref) {
  var _ref$language = _ref.language,
    language = _ref$language === void 0 ? 'text' : _ref$language,
    testId = _ref.testId,
    _ref$text = _ref.text,
    text = _ref$text === void 0 ? '' : _ref$text,
    _ref$codeTagProps = _ref.codeTagProps,
    codeTagProps = _ref$codeTagProps === void 0 ? {
      className: "language-".concat(language)
    } : _ref$codeTagProps,
    _ref$showLineNumbers = _ref.showLineNumbers,
    showLineNumbers = _ref$showLineNumbers === void 0 ? false : _ref$showLineNumbers,
    _ref$shouldCreatePare = _ref.shouldCreateParentElementForLines,
    shouldCreateParentElementForLines = _ref$shouldCreatePare === void 0 ? false : _ref$shouldCreatePare,
    _ref$shouldWrapLongLi = _ref.shouldWrapLongLines,
    shouldWrapLongLines = _ref$shouldWrapLongLi === void 0 ? false : _ref$shouldWrapLongLi,
    _ref$lineProps = _ref.lineProps,
    lineProps = _ref$lineProps === void 0 ? {} : _ref$lineProps,
    codeBidiWarnings = _ref.codeBidiWarnings,
    codeBidiWarningLabel = _ref.codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled = _ref.codeBidiWarningTooltipEnabled,
    _ref$astGenerator = _ref.astGenerator,
    astGenerator = _ref$astGenerator === void 0 ? null : _ref$astGenerator,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // TODO maybe we call this code or text everywhere; for now we match the API in
  // @atlaskit/codeblock
  var code = text;
  var generatorClassName = 'prismjs';
  var containerProps = _objectSpread(_objectSpread({}, rest), {}, {
    'data-testid': testId,
    className: rest.className ? "".concat(generatorClassName, " ").concat(rest.className) : generatorClassName
  });
  if (shouldWrapLongLines) {
    codeTagProps.style = {
      whiteSpace: 'pre-wrap',
      wordBreak: 'break-word'
    };
  } else {
    codeTagProps.style = {
      whiteSpace: 'pre'
    };
  }
  var codeBidiWarningConfig = {
    codeBidiWarnings: codeBidiWarnings,
    codeBidiWarningLabel: codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
  };

  // Tree + logic into rows
  var rows = (0, _process.default)({
    astGenerator: astGenerator,
    code: code,
    language: language,
    shouldCreateParentElementForLines: shouldCreateParentElementForLines || !!shouldWrapLongLines,
    lineProps: lineProps,
    showLineNumbers: showLineNumbers
  });

  // Rows + logic into a renderer
  return (0, _reactRenderer.default)({
    containerProps: containerProps,
    codeTagProps: codeTagProps,
    rows: rows,
    codeBidiWarningConfig: codeBidiWarningConfig
  });
});
var _default = Highlight;
exports.default = _default;