"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createLineElement;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _getInlineLineNumber = _interopRequireDefault(require("./get-inline-line-number"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function createLineElement(_ref) {
  var children = _ref.children,
    lineNumber = _ref.lineNumber,
    showLineNumbers = _ref.showLineNumbers,
    _ref$lineProps = _ref.lineProps,
    lineProps = _ref$lineProps === void 0 ? {} : _ref$lineProps,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? [] : _ref$className;
  var propsPassedInFromCodeBlock = typeof lineProps === 'function' ? lineProps(lineNumber) : lineProps;
  var properties = _objectSpread(_objectSpread({}, propsPassedInFromCodeBlock), {}, {
    className: className
  });
  var currentChildren = children;
  if (lineNumber && showLineNumbers) {
    // When syntax highlighting is NOT turned on, the entire LOC is just a single
    // child. We can then happily create the line number and the LOC as siblings...
    if (currentChildren.length === 1) {
      currentChildren = [(0, _getInlineLineNumber.default)(lineNumber)].concat((0, _toConsumableArray2.default)(currentChildren));
    } else {
      // ... However, when syntax highlighting IS on, a span is created for each
      // tokenised node in the AST (eg. <span>import</span><span>React</span>).
      // When shouldWrapLongLines is true, the row becomes `display: flex` and
      // forces all its children to be equal height. This can be a source of
      // visual bugs where a LOC is broken up weirdly into segments.
      //
      //  +---------------------------------------+
      //  | row                                   |
      //  |  +----+ +-------+ +--------+ +------+ |
      //  |  |line| |key    | |keywords| |key   | |
      //  |  |no. | |word   | |        | |word  | |
      //  |  |    | |       | |        | |      | |
      //  |  +----+ +-------+ +--------+ +------+ |
      //  +---------------------------------------+
      //
      // Nesting the children one layer deeper (i.e. creating an extra span)
      // ensures that the line number and the ENTIRE line of code are aligned by
      // the parent flexbox (the row).
      //
      //  +---------------------------------------------+
      //  | row                                         |
      //  | +----+  +--------------------------------+  |
      //  | |line|  | extra span we are creating     |  |
      //  | |no. |  |  +-------+ +--------+ +------+ |  |
      //  | |    |  |  |key    | |keywords| |key   | |  |
      //  | |    |  |  |word   | |        | |word  | |  |
      //  | |    |  |  |       | |        | |      | |  |
      //  | |    |  |  +-------+ +--------+ +------+ |  |
      //  | +----+  +--------------------------------+  |
      //  +---------------------------------------------+
      //
      currentChildren = [(0, _getInlineLineNumber.default)(lineNumber), {
        type: 'element',
        tagName: 'span',
        properties: {
          className: []
        },
        children: currentChildren
      }];
    }
  }
  return {
    type: 'element',
    tagName: 'span',
    properties: properties,
    children: currentChildren
  };
}