"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _createLineElement = _interopRequireDefault(require("./create-line-element"));
var _getInlineLineNumber = _interopRequireDefault(require("./get-inline-line-number"));
function createLineGenerator(lineProps, shouldCreateParentElementForLines, showLineNumbers) {
  return function (children, lineNumber) {
    var className = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    // Needed for more complex line creation
    if (shouldCreateParentElementForLines || className.length > 0) {
      return (0, _createLineElement.default)({
        children: children,
        lineNumber: lineNumber,
        showLineNumbers: showLineNumbers,
        lineProps: lineProps,
        className: className
      });
    } else {
      // Simple line creation without the bells and whistles
      if (showLineNumbers && lineNumber) {
        children.unshift((0, _getInlineLineNumber.default)(lineNumber));
      }
      return children;
    }
  };
}
var _default = createLineGenerator;
exports.default = _default;