"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getCodeTree;
function getCodeTree(language, code, astGenerator) {
  if (language === 'text' || !astGenerator) {
    return [{
      type: 'text',
      value: code
    }];
  }
  try {
    return astGenerator.highlight(code, language);
  } catch (e) {
    return [{
      type: 'text',
      value: code
    }];
  }
}