"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createChildren;
var _createElement = _interopRequireDefault(require("./create-element"));
function createChildren(codeBidiWarningConfig) {
  var childrenCount = 0;
  return function (children) {
    childrenCount += 1;
    return children.map(function (child, i) {
      return (0, _createElement.default)({
        node: child,
        codeBidiWarningConfig: codeBidiWarningConfig,
        key: "code-segment-".concat(childrenCount, "-").concat(i)
      });
    });
  };
}