"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createElement;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _bidiWarning = _interopRequireDefault(require("../../../bidi-warning"));
var _bidiWarningDecorator = _interopRequireDefault(require("../../../bidi-warning/bidi-warning-decorator"));
var _createChildren = _interopRequireDefault(require("./create-children"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function createClassNameString(classNames) {
  return classNames ? classNames.join(' ') : '';
}

// NOTE: This is a function call rather than a React component because, for
// unknown reasons, it appears to be more performant. We tried and measured both
// and this stacks up better than as a memoised React component. Something to look
// into in the future.
function createElement(_ref) {
  var node = _ref.node,
    codeBidiWarningConfig = _ref.codeBidiWarningConfig,
    key = _ref.key;
  if (node.type === 'text') {
    var value = node.value;
    // occasionally a numeric value is passed when the type is text
    var textValue = "".concat(value);
    if (codeBidiWarningConfig.codeBidiWarnings) {
      var decorated = (0, _bidiWarningDecorator.default)(textValue, function (_ref2) {
        var bidiCharacter = _ref2.bidiCharacter,
          index = _ref2.index;
        return /*#__PURE__*/_react.default.createElement(_bidiWarning.default, {
          bidiCharacter: bidiCharacter,
          key: index,
          label: codeBidiWarningConfig.codeBidiWarningLabel,
          tooltipEnabled: codeBidiWarningConfig.codeBidiWarningTooltipEnabled
        });
      });
      return decorated;
    }
    return textValue;
  } else {
    var properties = node.properties,
      tagName = node.tagName;
    var childrenCreator = (0, _createChildren.default)(codeBidiWarningConfig);
    var props = _objectSpread(_objectSpread({}, properties), {}, {
      className: createClassNameString(properties.className)
    });
    var children = childrenCreator(node.children);
    return /*#__PURE__*/_react.default.createElement(tagName, _objectSpread({
      key: key
    }, props), children);
  }
}