"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ReactRenderer;
var _react = _interopRequireDefault(require("react"));
var _createElement = _interopRequireDefault(require("./create-element"));
/**
 * __React Renderer__
 *
 * A component that receives processed code lines and renders them into the code
 * rows inside the wrapping span and nested code tag, applying passed props and
 * code bidi warning config settings.
 */
function ReactRenderer(_ref) {
  var containerProps = _ref.containerProps,
    codeTagProps = _ref.codeTagProps,
    rows = _ref.rows,
    codeBidiWarningConfig = _ref.codeBidiWarningConfig;
  var renderedRows = rows.map(function (node, i) {
    return (0, _createElement.default)({
      node: node,
      codeBidiWarningConfig: codeBidiWarningConfig,
      key: "code-segment".concat(i)
    });
  });
  return /*#__PURE__*/_react.default.createElement("span", containerProps, /*#__PURE__*/_react.default.createElement("code", codeTagProps, renderedRows));
}