import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import Tooltip from '@atlaskit/tooltip';
import { Decorator } from './styled';
/**
 * __Bidi Warning__
 *
 * A component used to render a bidi character warning.
 * A bidi character can be used to perform a "bidi override attack".
 *
 * See https://hello.atlassian.net/wiki/spaces/PRODSEC/pages/1347434677/PSHELP-2943+Investigate+Trojan+Source+Attack+Vulnerability#1)-Providing-visual-cues-for-our-Customers-in-our-affected-products
 */
export default function BidiWarning({
  testId,
  bidiCharacter,
  skipChildren,
  tooltipEnabled,
  label = 'Bidirectional characters change the order that text is rendered. This could be used to obscure malicious code.'
}) {
  if (tooltipEnabled) {
    return (
      /*#__PURE__*/
      // Following patches, this should be updated to use the render props signature which will provide aria attributes.
      // Note: this should be tested, as initial testing did not see attributes work with current tooltip implementation.
      React.createElement(Tooltip, {
        content: label,
        tag: CustomizedTagWithRef
      }, /*#__PURE__*/React.createElement(Decorator, {
        testId: testId,
        bidiCharacter: bidiCharacter
      }, skipChildren ? null : bidiCharacter))
    );
  }
  return /*#__PURE__*/React.createElement(Decorator, {
    testId: testId,
    bidiCharacter: bidiCharacter
  }, skipChildren ? null : bidiCharacter);
}
const CustomizedTagWithRef = /*#__PURE__*/React.forwardRef((props, ref) => {
  const {
    children,
    ...rest
  } = props;
  return /*#__PURE__*/React.createElement("span", _extends({}, rest, {
    ref: ref
  }), children);
});